#!/bin/sh

#  iTMCopyBundleResources.sh
#  iTunesMobile
#
#  Created by Jeff Lee on 6/17/11.
#  Copyright 2011 Apple Inc. All rights reserved.

SCRIPT_PATH="${0#./}"
SCRIPT_BASE_PATH="${SCRIPT_PATH%/*}"

BUNDLE_NAME=$1.bundle
SRC_ROOT_PATH="$SCRIPT_BASE_PATH/../ResourceBundles"
DST_ROOT_PATH=$CONFIGURATION_BUILD_DIR

# B&I puts the final binaries in DSTROOT
if [ -r "$DSTROOT" ]; then
    echo "Looks like a B&I build"
    DST_ROOT_PATH=$DSTROOT/Applications
fi	

# Piece together our actual src/dst resources
SRC_RESOURCES=$SRC_ROOT_PATH/$BUNDLE_NAME
DST_RESOURCES=$DST_ROOT_PATH/$CONTENTS_FOLDER_PATH

# Copy
if [ -r "$SRC_RESOURCES" ]; then
    echo "$SRC_RESOURCES exists";
fi;
if [ -r "$DST_RESOURCES" ]; then
    echo "$DST_RESOURCES exists";
fi;

echo "Copying resources from $SRC_RESOURCES to $DST_RESOURCES"
if [ -r "$SRC_RESOURCES" -a -r "$DST_RESOURCES" ]; then
    cp -R $SRC_RESOURCES/* $DST_RESOURCES
    echo "Success!"
else
    echo "Source or Dest does not exist"
fi    

