#!/usr/bin/perl
#
use Getopt::Long;
use Sys::Hostname;
use Time::Piece;
use strict;

my $resourceFile = "";
my $outputFile = "";
my $resourceName;
my $line;
my $usage = "";
my @symptomArray = ("    <key>SYMPTOM_ARRAY</key>\n","    <array>\n");
my @syndromeArray = ("    <key>SIMPLE_SYNDROME_DETECTION_ARRAY</key>\n","    <array>\n");
my @additionalHandlerArray = ("    <key>ADDITONAL_HANDLER_ARRAY</key>\n","    <array>\n");

sub usage
{
    print " -r resource-file -o output-file \n";
    exit;
}

sub parse
{
    my $line;
    my @array =  @_;

    $line = <PLISTFILE>;
    if ($line =~ "<array>") {
        my $nestCount = 1;
        while ($line = <PLISTFILE>) {
            if ($line =~ "<array>") {
                $nestCount++;
            }
            if ($line =~ "</array>") {
                $nestCount--;
                if ($nestCount == 0) {
                    last;
                }
            }
            push (@array, $line);
        }
    } else {
        print "missed expected <array>";
    }
    return @array;
}

GetOptions(
        'resourceFile|r=s'    => \$resourceFile,
        'outputFile|o=s'    => \$outputFile,
        'help|h'            => \$usage,
    ) or die "Bad usage\n";

if ($usage) {
    usage();
}


open(RESOURCEFILE, $resourceFile) or die("Unable to open resource file $resourceFile");
open(OUTFILE, "> $outputFile") or die("Unable to open output file $outputFile");

while ($resourceName = <RESOURCEFILE>) {
    my $validationString = `plutil -lint $resourceName`;

   if (!($validationString =~ "OK")) {
        system("plutil -lint $resourceName");
        next;
   }

    open(PLISTFILE, $resourceName) or die("Unable to open input file $resourceName");

    while ($line = <PLISTFILE>) {

        if ($line =~ "SYMPTOM_ARRAY") {
            @symptomArray = parse(@symptomArray);
        }

        if ($line =~ "SIMPLE_SYNDROME_DETECTION_ARRAY") {
            @syndromeArray = parse(@syndromeArray);
        }

        if ($line =~ "ADDITONAL_HANDLER_ARRAY") {
            @additionalHandlerArray = parse(@additionalHandlerArray);
        }
    }
}
push (@symptomArray,  "    </array>\n");
push (@syndromeArray, "    </array>\n");
push (@additionalHandlerArray, "    </array>\n");

my $date = localtime->strftime('%T %a %x');
my $host = hostname();

print OUTFILE "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
print OUTFILE "<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n";
print OUTFILE "<plist version=\"1.0\">\n";
print OUTFILE "<dict>\n";
print OUTFILE @symptomArray;
print OUTFILE @syndromeArray;
print OUTFILE @additionalHandlerArray;
print OUTFILE "    <key>BUILD_DETAILS_ARRAY</key>\n";
print OUTFILE "    <array>\n";
print OUTFILE "        <dict>\n";
print OUTFILE "            <key>BUILD_DATE</key>\n";
print OUTFILE "            <string>$date</string>\n";
print OUTFILE "            <key>BUILD_MACHINE</key>\n";
print OUTFILE "            <string>$host</string>\n";
print OUTFILE "        </dict>\n";
print OUTFILE "    </array>\n";
print OUTFILE "</dict>\n";
print OUTFILE "</plist>\n";
