/*
	File:		gpus_texture.c

	Copyright:	© 1999-2010 by Apple Inc., all rights reserved.

	Writers:
		Bob Beretta
*/

#include "glr_config.h"

#include <GPUSupport/gpus_internal.h>
#include <GPUSupport/gpus_export.h>
#include <GPUSupport/gpus_texture.h>
#include <GPUSupport/gpus_memory.h>

enum32_t gldGetTextureLevelInfo(GLDContext ctx, GLDTexture tex,
	int32_t face, int32_t level, enum32_t pname, int32_t *params)
{
	return gpumGetTextureLevelInfo(ctx, tex, face, level, pname, params,
		glrGetTextureInfo);
}

enum32_t gldRestoreTextureData(GLDShareGroup shr, GLDTexture tex,
	int32_t face, int32_t level, enum32_t access)
{
	return gpumRestoreTextureData(shr, tex, face, level, access,
		glrRestoreStandardTextureData);
}

enum32_t gldReadTextureData(GLDShareGroup shr, GLDTexture tex,
	int32_t face, int32_t level, enum32_t format, enum32_t type, void *pixels, enum32_t access)
{
	return gpumReadTextureData(shr, tex, face, level, format, type, pixels, access,
		glrReadTextureData);
}


#ifndef GPUS_MERCURY
extern bool32_t gpusGetKernelTextureStandard(GLDShareGroup shared,
    GLDTexture texture, IOByteCount size_bytes, IOByteCount vram_bytes,
    IOByteCount vram_rowbytes, IOByteCount pixel_bytes, IOByteCount sysm_rowbytes)
{
	return gpumGetKernelTextureStandard(shared, texture, size_bytes, vram_bytes,
		vram_rowbytes, pixel_bytes, sysm_rowbytes,
		&texture->in);
}

extern bool32_t gpusGetKernelTextureAGPRef(GLDShareGroup shared,
    GLDTexture texture, IOVirtualAddress texture_address,
    IOVirtualAddress agp_base_address, IOByteCount agp_size)
{
	return gpumGetKernelTextureAGPRef(shared, texture, texture_address,
		agp_base_address, agp_size,
		&texture->in);
}

extern bool32_t gpusGetKernelTextureOutOfLine(GLDShareGroup shared,
    GLDTexture texture, IOByteCount size_bytes,
    IOByteCount vram_bytes, IOByteCount vram_rowbytes, IOByteCount pixel_bytes,
    IOVirtualAddress agp_base_address, IOByteCount agp_size)
{
	return gpumGetKernelTextureOutOfLine(shared, texture, size_bytes, vram_bytes, vram_rowbytes,
		pixel_bytes, agp_base_address, agp_size,
		&texture->in);
}

extern bool32_t gpusGetKernelTextureSurface(GLDShareGroup shared,
    GLDTexture texture, uint32_t source)
{
	return gpumGetKernelTextureSurface(shared, texture, source,
		&texture->in);
}

extern bool32_t gpusGetKernelTextureIOSurface(GLDShareGroup shared,
    GLDTexture texture, uint32_t object_type, uint32_t pixel_bytes)
{
	return gpumGetKernelTextureIOSurface(shared, texture, object_type, pixel_bytes,
		&texture->in);
}
#endif

