/*
	File:		gpus_format.c

	Copyright:	© 1999-2010 by Apple Inc., all rights reserved.

	Writers:
		Bob Beretta
*/

#include "glr_config.h"

#include <GPUSupport/gpus_internal.h>
#include <GPUSupport/gpus_init.h>

enum32_t gldChoosePixelFormat(GLDPixelFormat **fmt_ret, const int32_t *attribs)
{
	// Call into GPUSupport with the IOData for this plugin.
	return gpumChoosePixelFormat(fmt_ret, attribs,
		&gpus_io_data, glrSanitizePixelFormat);
}

enum32_t gldDestroyPixelFormat(GLDPixelFormat *fmt)
{
	return gpumDestroyPixelFormat(fmt, &gpus_io_data);
}

