
#import "SoftwareUpdates.js"

/**
 *       Function: softwareupdatesTest_verifyMenuContents
 *           Verifies that expect menu items.
 *   
 *  \return 1 success, otherwise 0
 **/

function softwareupdatesTest_verifyMenuContents() {
    if ( ! softwareupdates.goTo()) {
        this.testError = "Fail to get to Settings>General>Software Updates";
        return this.testResult = 0;
    }

    if ( ! softwareupdates.appMenu().verifyMenuContents(softwareupdates.menuItems) ) {
        this.testError = "Menu contents verification failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: softwareupdatesTest_verifyMenuNavigation
 *           Verifies the basic navigation of the page.
 *   
 *  \return 1 success, otherwise 0
 **/

function softwareupdatesTest_verifyMenuNavigation() {
    if ( ! softwareupdates.goTo()) {
        this.testError = "Fail to get to Settings>General>Software Updates";
        return this.testResult = 0;
    }

    if ( ! softwareupdates.appMenu().verifyMenuNavigation(softwareupdates.menuItems, softwareupdates.menuItemsNavigation) ) {
        this.testError = "Menu navigation verification failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: softwareupdatesTest_verifyDefaultValues
 *           Verifies the default values for Settings>Audio & Video. Assumes that the defaults
 *           are currently set.
 *   
 *  \return 1 success, otherwise 0
 **/

function softwareupdatesTest_verifyDefaultValues() {
    if ( ! softwareupdates.goTo()) {
        this.testError = "Fail to get to Settings>General>Software Updates";
        return this.testResult = 0;
    }

    if ( ! softwareupdates.appMenu().verifyDefaultValues(softwareupdates.menuItemsWithValues, softwareupdates.menuItemsDefaultValues) ) {
        this.testError = "Menu default value verification failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: softwareupdatesTest_verifyToggleValues
 *           Verify that toggle values can be changed to the expected values.
 *   
 *  \return 1 success, otherwise 0
 **/

function softwareupdatesTest_verifyToggleValues() {
    if ( ! softwareupdates.goTo()) {
        this.testError = "Fail to get to Settings>General>Software Updates";
        return this.testResult = 0;
    }

    if ( ! softwareupdates.appMenu().verifyToggleValues(softwareupdates.toggleMenuItemsAndValues, []) ) {
        this.testError = "Menu toggle value verification failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: softwareupdatesTest_setValuesToDefaults
 *           Tries to set all values back to there defaults.
 *   
 *  \return 1 success, otherwise 0
 **/

function softwareupdatesTest_setValuesToDefaults() {
    if ( ! softwareupdates.goTo()) {
        this.testError = "Fail to get to Settings>General>Software Updates";
        return this.testResult = 0;
    }

    var theErrorCount = 0;

    // Toggles
    var keys = Object.keys(softwareupdates.toggleMenuItemsAndValues);
    var ignoreToggles = [];
    for (var i = 0; i < keys.length; ++i) {
        if (ignoreToggles.indexOf(keys[i]) > -1) {
            // skipping
            continue;
        }
        if ( ! softwareupdates.appMenu().toggleItem(keys[i], softwareupdates.menuItemsDefaultValues[keys[i]], softwareupdates.toggleMenuItemsAndValues[keys[i]])) {
            ++theErrorCount;
            UIALogger.logError("Failed to set value " + keys[i] + " back to " + softwareupdates.menuItemsDefaultValues[keys[i]]);
        }
    }

    if (theErrorCount > 0) {
        this.testError = "Setting values back to defaults failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: softwareupdatesTest_setToggleValueTo
 *           Sets the value for a toggle.
 *   
 *  \return 1 success, otherwise 0
 **/

function softwareupdatesTest_setToggleValueTo() {
    if (this.argv.length < 2) {
        this.testError = "Arguments not specified";
        return this.testResult = 0;
    }
    var item = this.argv[0];
    var value = this.argv[1];

    if ( ! softwareupdates.goToAndSetValueForToggle(item, value) ) {
        this.testError = "Failed to set value";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

