
#import "./General.js"

// --------------------------------------------------------------------------------
//      Object: softwareupdates
//              softwareupdates is an ATVAApp object for interacting with the
//              Settings/General/Software Updates appliance on Apple TV.
// --------------------------------------------------------------------------------

if (typeof softwareupdates == 'undefined') {
    softwareupdates = new ATVAApp("Software Updates");
}

if (typeof softwareupdates != 'undefined') {
    softwareupdates._objectName = "softwareupdates";

    softwareupdates.kUpdateSoftware = "Update Software";
    softwareupdates.kAutomaticallyApplyUpdates = "Automatically Apply Updates";

    softwareupdates.kAutomaticallyApplyUpdatesOn = "On";
    softwareupdates.kAutomaticallyApplyUpdatesOff = "Off";
    
    softwareupdates.menuItems = [
        softwareupdates.kUpdateSoftware,
        softwareupdates.kAutomaticallyApplyUpdates
    ];
    softwareupdates.menuItemsWithValues = [
        softwareupdates.kAutomaticallyApplyUpdates
    ];

    softwareupdates.toggleMenuItemsAndValues = undefined;
    softwareupdates.setToggleMenuItemsAndValues = function setToggleMenuItemsAndValues() {
        this.toggleMenuItemsAndValues = {};
        this.toggleMenuItemsAndValues[this.kAutomaticallyApplyUpdates] = [this.kAutomaticallyApplyUpdatesOn, this.kAutomaticallyApplyUpdatesOff];
    }
    softwareupdates.setToggleMenuItemsAndValues();

    softwareupdates.menuItemsDefaultValues = undefined;
    softwareupdates.setMenuItemsDefaultValues = function setMenuItemsDefaultValues() {
        this.menuItemsDefaultValues = {};
        this.menuItemsDefaultValues[this.kAutomaticallyApplyUpdates] = this.kAutomaticallyApplyUpdatesOff;
    }
    softwareupdates.setMenuItemsDefaultValues();

    softwareupdates.menuItemsNavigation = undefined;
    softwareupdates.setMenuItemsNavigation = function setMenuItemsNavigation() {
        this.menuItemsNavigation = {};
        this.menuItemsNavigation[this.kUpdateSoftware] = [
            {"action":"up", "result":"noop"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"},
        ];
        this.menuItemsNavigation[this.kAutomaticallyApplyUpdates] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"noop"},
        ];
    }
    softwareupdates.setMenuItemsNavigation();

    softwareupdates.appMenu = function appMenu() {
        if ( ! this._appMenu ) {
            this._appMenu = new ATVAPageList(this._title);
            this._appMenu.setListScrolls(false);
        }
        return( this._appMenu );
    }

    softwareupdates.goTo = function goTo() {
        // Indexes are not saved when we go back to the Main Menu
        this.appMenu().resetList();
        if (general.goToAndSelect(this._title)) {
            return(this.fromMenu());
        }
        UIALogger.logError(this._objectName + ".goTo(): failed to get to " + this._title);
        return(undefined);
    }
}
