
#import "Restrictions.js"

/**
 *       Function: restrictionsTest_verifyMenuContents
 *           Verifies that expect menu items.
 *   
 *  \return 1 success, otherwise 0
 **/

function restrictionsTest_verifyMenuContents() {
    if (this.argv.length < 1) {
        this.testError = "Arguments not specified";
        return this.testResult = 0;
    }
    var passcodeOn = false;
    if (this.argv[0].toUpperCase() == "TRUE") {
        passcodeOn = true;
    }
    restrictions.setPasscode(passcodeOn);

    if ( ! restrictions.goTo()) {
        this.testError = "Fail to get to Settings>General>Restrictions";
        return this.testResult = 0;
    }

    restrictions.setMenuItems();
    if ( ! restrictions.appMenu().verifyMenuContents(restrictions.menuItems) ) {
        this.testError = "Menu contents verification failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: restrictionsTest_verifyMenuNavigation
 *           Verifies the basic navigation of the page.
 *   
 *  \return 1 success, otherwise 0
 **/

function restrictionsTest_verifyMenuNavigation() {
    if (this.argv.length < 1) {
        this.testError = "Arguments not specified";
        return this.testResult = 0;
    }
    var passcodeOn = false;
    if (this.argv[0].toUpperCase() == "TRUE") {
        passcodeOn = true;
    }
    restrictions.setPasscode(passcodeOn);

    if ( ! restrictions.goTo()) {
        this.testError = "Fail to get to Settings>General>Restrictions";
        return this.testResult = 0;
    }

    restrictions.setMenuItems();
    restrictions.setMenuItemsNavigation();
    if ( ! restrictions.appMenu().verifyMenuNavigation(restrictions.menuItems, restrictions.menuItemsNavigation) ) {
        this.testError = "Menu navigation verification failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: restrictionsTest_verifyDefaultValues
 *           Verifies the default values. Assumes that the defaults
 *           are currently set.
 *   
 *  \return 1 success, otherwise 0
 **/

function restrictionsTest_verifyDefaultValues() {
    if (this.argv.length < 1) {
        this.testError = "Arguments not specified";
        return this.testResult = 0;
    }
    var passcodeOn = false;
    if (this.argv[0].toUpperCase() == "TRUE") {
        passcodeOn = true;
    }
    restrictions.setPasscode(passcodeOn);

    if ( ! restrictions.goTo()) {
        this.testError = "Fail to get to Settings>General>Restrictions";
        return this.testResult = 0;
    }

    restrictions.setMenuItemsWithValues();
    if ( ! restrictions.appMenu().verifyDefaultValues(restrictions.menuItemsWithValues, restrictions.pcApplianceMenuItemsAndDefaultValues) ) {
        this.testError = "Menu navigation verification failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: restrictionTest_turnOn
 *           Go to Settings>General>Restrictions and turn on.
 *   
 *  \param pin (string) - four digit pin
 *   
 *  \return 1 if successfully signed in, otherwise 0
 **/

function restrictionTest_turnOn() {
    if (this.argv.length < 1) {
        this.testError = "Arguments not specified";
        return this.testResult = 0;
    }
    var pin = this.argv[0];

    restrictions.setPasscode(false);

    if ( ! restrictions.goTo()) {
        this.testError = "Fail to get to Settings>General>Restrictions";
        return this.testResult = 0;
    }
    if ( ! restrictions.turnParentalControlsOn(pin)) {
        this.testError = "Fail to turn on Restrictions";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: restrictionTest_turnOff
 *           Go to Settings>General>Restrictions and turn off.
 *   
 *  \param pin (string) - four digit pin
 *   
 *  \return 1 if successfully signed in, otherwise 0
 **/

function restrictionTest_turnOff() {
    if (this.argv.length < 1) {
        this.testError = "Arguments not specified";
        return this.testResult = 0;
    }
    var pin = this.argv[0];

    restrictions.setPasscode(true);

    if ( ! restrictions.goTo()) {
        this.testError = "Fail to get to Settings>General>Restrictions";
        return this.testResult = 0;
    }
    if ( ! restrictions.turnParentalControlsOff(pin)) {
        this.testError = "Fail to turn on Restrictions";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: restrictionsTest_changePin
 *           Go to Settings>General>Restrictions and change pin.
 *   
 *  \param oldPin (string) - four digit pin
 *  \param newPin (string) - four digit pin
 *   
 *  \return 1 if successfully signed in, otherwise 0
 **/

function restrictionsTest_changePin() {
    if (this.argv.length < 2) {
        this.testError = "Arguments not specified";
        return this.testResult = 0;
    }
    var oldPin = this.argv[0];
    var newPin = this.argv[1];

    restrictions.setPasscode(true);

    if ( ! restrictions.goTo()) {
        this.testError = "Fail to get to Settings>General>Restrictions";
        return this.testResult = 0;
    }
    if ( ! restrictions.changeParentalControlsPin(oldPin, newPin)) {
        this.testError = "Fail to change pin";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}
