
#import "General.js"

// --------------------------------------------------------------------------------
//      Object: restrictions
//              restrictions is an ATVAApp object for interacting with the
//              Restrictions appliance on Apple TV.
// --------------------------------------------------------------------------------

if (typeof restrictions == 'undefined') {
    restrictions = new ATVAApp("Restrictions");
}

if (typeof restrictions != 'undefined') {
    restrictions._objectName = "restrictions";

    restrictions._passcodeEnabled = false;
    restrictions.setPasscode = function setPasscode(isOn) {
        if (isOn) {
            this._passcodeEnabled = true;
        }
        else {
            this._passcodeEnabled = false;
        }
    }

    // Turn on, off, change
    restrictions.kPCTurnOnString = "Turn On Restrictions";
    restrictions.kPCTurnOffString = "Turn Off Restrictions";
    restrictions.kPCChangePinString = "Change Passcode";

    // Ratings
    // TODO: Movies and TV Shows items lose the "To" at the end when set to "No". Breaks.
    restrictions.kPCPurchaseRentalString = "Purchase & Rental";
    restrictions.kPCRatingsCountryString = "Ratings For";
    restrictions.kPCMovieRatingString = "Restrict Movies To";
    restrictions.kPCTVShowRatingString = "Restrict TV Shows To";
    restrictions.kPCExplicitMusicPodcastString = "Explicit Music & Podcasts";

    // Appliances
    restrictions.kPCAMusicString = "Music";
    restrictions.kPCANetflixString = "Netflix";
    restrictions.kPCAHuluPlusString = "Hulu Plus";
    restrictions.kPCAHBOGOString = "HBO GO";
    restrictions.kPCAAppleEventsString = "Apple Events";
    restrictions.kPCAiTunesRadioString = "iTunes Radio";
    restrictions.kPCAESPNString = "ESPN";
    restrictions.kPCAMLBString = "MLB.TV";
    restrictions.kPCANBAString = "NBA";
    restrictions.kPCANHLString = "NHL";
    restrictions.kPCASkyNewsString = "Sky News";
    restrictions.kPCATrailersString = "Trailers";
    restrictions.kPCAYouTubeString = "YouTube";
    restrictions.kPCAVimeoString = "Vimeo";
    restrictions.kPCAQelloString = "Qello";
    restrictions.kPCACrunchyrollString = "Crunchyroll";
    restrictions.kPCAPodcastsString = "Podcasts";
    restrictions.kPCARadioString = "Radio";
    restrictions.kPCAiCloudPhotosString = "iCloud Photos";
    restrictions.kPCAFlickrString = "Flickr";
    restrictions.kPCAWSJString = "WSJ Live";

    // Appliances Values
    restrictions.kPCApplianceShowString = "Show";
    restrictions.kPCApplianceAskString = "Ask";
    restrictions.kPCApplianceHideString = "Hide";

    // iCloud Photos Menu
    restrictions.kPCAICPiCloudPhotosString = "iCloud Photos";
    restrictions.kPCAICPSharedAlbumInvitationsString = "Shared Album Invitations";

    // AirPlay
    restrictions.kPCAirPlaySettingsString = "AirPlay Settings";
    restrictions.kPCConferenceRoomDisplayString = "Conference Room Display";

    restrictions.menuItems = undefined;
    restrictions.pcOnOffMenuItems = function pcOnOffMenuItems() {
        if (this._passcodeEnabled) {
            return([
                this.kPCTurnOffString,
                this.kPCChangePinString
            ]);
        }
        else {
            return([
                this.kPCTurnOnString
            ]);
        }
    }
    restrictions.pcRatingMenuItems = function pcRatingMenuItems() {
        return([
            this.kPCPurchaseRentalString,
            this.kPCRatingsCountryString,
            this.kPCMovieRatingString,
            this.kPCTVShowRatingString,
            this.kPCExplicitMusicPodcastString
        ]);
    }
    restrictions.pcApplianceMenuItems = function pcApplianceMenuItems() {
        return([
            this.kPCAMusicString,
            this.kPCANetflixString,
            this.kPCAHuluPlusString,
            this.kPCAHBOGOString,
            this.kPCAAppleEventsString,
            this.kPCAiTunesRadioString,
            this.kPCAESPNString,
            this.kPCAMLBString,
            this.kPCANBAString,
            this.kPCANHLString,
            this.kPCASkyNewsString,
            this.kPCATrailersString,
            this.kPCAYouTubeString,
            this.kPCAVimeoString,
            this.kPCAQelloString,
            this.kPCACrunchyrollString,
            this.kPCAPodcastsString,
            this.kPCARadioString,
            this.kPCAiCloudPhotosString,
            this.kPCAFlickrString,
            this.kPCAWSJString
        ]);
    }
    restrictions.pciCloudPhotosApplianceMenuItems = function pciCloudPhotosApplianceMenuItems() {
        return([
            this.kPCAICPiCloudPhotosString,
            this.kPCAICPSharedAlbumInvitationsString
        ]);
    }
    restrictions.pcAirPlayMenuItems = function pcAirPlayMenuItems() {
        return([
            this.kPCAirPlaySettingsString,
            this.kPCConferenceRoomDisplayString
        ]);
    }
    restrictions.setMenuItems = function setMenuItems() {
        this.menuItems = this.pcOnOffMenuItems();
        this.menuItems = this.menuItems.concat(this.pcRatingMenuItems());
        this.menuItems = this.menuItems.concat(this.pcApplianceMenuItems());
        this.menuItems = this.menuItems.concat(this.pcAirPlayMenuItems());
    }

    restrictions.menuItemsWithValues = undefined;
    restrictions.setMenuItemsWithValues = function setMenuItemsWithValues() {
        //this.menuItemsWithValues = this.pcRatingMenuItems();
        //this.menuItemsWithValues.concat(this.pcApplianceMenuItems());
        //this.menuItemsWithValues.concat(this.pcAirPlayMenuItems());
        this.menuItemsWithValues = this.pcApplianceMenuItems();
    }

    restrictions.pcApplianceMenuItemsAndValues = function pcApplianceMenuItemsAndValues() {
        if (this._passcodeEnabled) {
            var tmpDict = {};
            tmpDict[this.kPCAMusicString] = [this.kPCApplianceShowString, this.kPCApplianceAskString, this.kPCApplianceHideString];
            tmpDict[this.kPCANetflixString] = [this.kPCApplianceShowString, this.kPCApplianceAskString, this.kPCApplianceHideString];
            tmpDict[this.kPCAHuluPlusString] = [this.kPCApplianceShowString, this.kPCApplianceAskString, this.kPCApplianceHideString];
            tmpDict[this.kPCAHBOGOString] = [this.kPCApplianceShowString, this.kPCApplianceAskString, this.kPCApplianceHideString];
            tmpDict[this.kPCAAppleEventsString] = [this.kPCApplianceShowString, this.kPCApplianceAskString, this.kPCApplianceHideString];
            tmpDict[this.kPCAiTunesRadioString] = [this.kPCApplianceShowString, this.kPCApplianceAskString, this.kPCApplianceHideString];
            tmpDict[this.kPCAESPNString] = [this.kPCApplianceShowString, this.kPCApplianceAskString, this.kPCApplianceHideString];
            tmpDict[this.kPCAMLBString] = [this.kPCApplianceShowString, this.kPCApplianceAskString, this.kPCApplianceHideString];
            tmpDict[this.kPCANBAString] = [this.kPCApplianceShowString, this.kPCApplianceAskString, this.kPCApplianceHideString];
            tmpDict[this.kPCANHLString] = [this.kPCApplianceShowString, this.kPCApplianceAskString, this.kPCApplianceHideString];
            tmpDict[this.kPCASkyNewsString] = [this.kPCApplianceShowString, this.kPCApplianceAskString, this.kPCApplianceHideString];
            tmpDict[this.kPCATrailersString] = [this.kPCApplianceShowString, this.kPCApplianceAskString, this.kPCApplianceHideString];
            tmpDict[this.kPCAYouTubeString] = [this.kPCApplianceShowString, this.kPCApplianceAskString, this.kPCApplianceHideString];
            tmpDict[this.kPCAVimeoString] = [this.kPCApplianceShowString, this.kPCApplianceAskString, this.kPCApplianceHideString];
            tmpDict[this.kPCAQelloString] = [this.kPCApplianceShowString, this.kPCApplianceAskString, this.kPCApplianceHideString];
            tmpDict[this.kPCACrunchyrollString] = [this.kPCApplianceShowString, this.kPCApplianceAskString, this.kPCApplianceHideString];
            tmpDict[this.kPCAPodcastsString] = [this.kPCApplianceShowString, this.kPCApplianceAskString, this.kPCApplianceHideString];
            tmpDict[this.kPCARadioString] = [this.kPCApplianceShowString, this.kPCApplianceAskString, this.kPCApplianceHideString];
            tmpDict[this.kPCAFlickrString] = [this.kPCApplianceShowString, this.kPCApplianceAskString, this.kPCApplianceHideString];
            tmpDict[this.kPCAWSJString] = [this.kPCApplianceShowString, this.kPCApplianceAskString, this.kPCApplianceHideString];
            return(tmpDict);
        }
        else {
            var tmpDict = {};
            tmpDict[this.kPCAMusicString] = [this.kPCApplianceShowString, this.kPCApplianceHideString];
            tmpDict[this.kPCANetflixString] = [this.kPCApplianceShowString, this.kPCApplianceHideString];
            tmpDict[this.kPCAHuluPlusString] = [this.kPCApplianceShowString, this.kPCApplianceHideString];
            tmpDict[this.kPCAHBOGOString] = [this.kPCApplianceShowString, this.kPCApplianceHideString];
            tmpDict[this.kPCAAppleEventsString] = [this.kPCApplianceShowString, this.kPCApplianceHideString];
            tmpDict[this.kPCAiTunesRadioString] = [this.kPCApplianceShowString, this.kPCApplianceHideString];
            tmpDict[this.kPCAESPNString] = [this.kPCApplianceShowString, this.kPCApplianceHideString];
            tmpDict[this.kPCAMLBString] = [this.kPCApplianceShowString, this.kPCApplianceHideString];
            tmpDict[this.kPCANBAString] = [this.kPCApplianceShowString, this.kPCApplianceHideString];
            tmpDict[this.kPCANHLString] = [this.kPCApplianceShowString, this.kPCApplianceHideString];
            tmpDict[this.kPCASkyNewsString] = [this.kPCApplianceShowString, this.kPCApplianceHideString];
            tmpDict[this.kPCATrailersString] = [this.kPCApplianceShowString, this.kPCApplianceHideString];
            tmpDict[this.kPCAYouTubeString] = [this.kPCApplianceShowString, this.kPCApplianceHideString];
            tmpDict[this.kPCAVimeoString] = [this.kPCApplianceShowString, this.kPCApplianceHideString];
            tmpDict[this.kPCAQelloString] = [this.kPCApplianceShowString, this.kPCApplianceHideString];
            tmpDict[this.kPCACrunchyrollString] = [this.kPCApplianceShowString, this.kPCApplianceHideString];
            tmpDict[this.kPCAPodcastsString] = [this.kPCApplianceShowString, this.kPCApplianceHideString];
            tmpDict[this.kPCARadioString] = [this.kPCApplianceShowString, this.kPCApplianceHideString];
            tmpDict[this.kPCAFlickrString] = [this.kPCApplianceShowString, this.kPCApplianceHideString];
            tmpDict[this.kPCAWSJString] = [this.kPCApplianceShowString, this.kPCApplianceHideString];
            return(tmpDict);
        }
    }
    restrictions.pciCloudPhotosApplianceMenuItemsAndValues = function pciCloudPhotosApplianceMenuItemsAndValues() {
        if (this._passcodeEnabled) {
            var tmpDict = {};
            tmpDict[this.kPCAICPiCloudPhotosString] = [this.kPCApplianceShowString, this.kPCApplianceAskString, this.kPCApplianceHideString];
            tmpDict[this.kPCAICPSharedAlbumInvitationsString] = [this.kPCApplianceShowString, this.kPCApplianceHideString];
            return(tmpDict);
        }
        else {
            var tmpDict = {};
            tmpDict[this.kPCAICPiCloudPhotosString] = [this.kPCApplianceShowString, this.kPCApplianceHideString];
            tmpDict[this.kPCAICPSharedAlbumInvitationsString] = [this.kPCApplianceShowString, this.kPCApplianceHideString];
            return(tmpDict);
        }
    }
    restrictions.pcApplianceMenuItemsAndDefaultValues = function pcApplianceMenuItemsAndDefaultValues() {
        if (this._passcodeEnabled) {
            var tmpDict = {};
            tmpDict[this.kPCAMusicString] = this.kPCApplianceShowString;
            tmpDict[this.kPCANetflixString] = this.kPCApplianceAskString;
            tmpDict[this.kPCAHuluPlusString] = this.kPCApplianceShowString;
            tmpDict[this.kPCAHBOGOString] = this.kPCApplianceShowString;
            tmpDict[this.kPCAAppleEventsString] = this.kPCApplianceShowString;
            tmpDict[this.kPCAiTunesRadioString] = this.kPCApplianceShowString;
            tmpDict[this.kPCAESPNString] = this.kPCApplianceShowString;
            tmpDict[this.kPCAMLBString] = this.kPCApplianceShowString;
            tmpDict[this.kPCANBAString] = this.kPCApplianceShowString;
            tmpDict[this.kPCANHLString] = this.kPCApplianceShowString;
            tmpDict[this.kPCASkyNewsString] = this.kPCApplianceShowString;
            tmpDict[this.kPCATrailersString] = this.kPCApplianceShowString;
            tmpDict[this.kPCAYouTubeString] = this.kPCApplianceAskString;
            tmpDict[this.kPCAVimeoString] = this.kPCApplianceShowString;
            tmpDict[this.kPCAQelloString] = this.kPCApplianceShowString;
            tmpDict[this.kPCACrunchyrollString] = this.kPCApplianceShowString;
            tmpDict[this.kPCAPodcastsString] = this.kPCApplianceAskString;
            tmpDict[this.kPCARadioString] = this.kPCApplianceShowString;
            tmpDict[this.kPCAFlickrString] = this.kPCApplianceAskString;
            tmpDict[this.kPCAWSJString] = this.kPCApplianceShowString;
            return(tmpDict);
        }
        else {
            var tmpDict = {};
            tmpDict[this.kPCAMusicString] = this.kPCApplianceShowString;
            tmpDict[this.kPCANetflixString] = this.kPCApplianceShowString;
            tmpDict[this.kPCAHuluPlusString] = this.kPCApplianceShowString;
            tmpDict[this.kPCAHBOGOString] = this.kPCApplianceShowString;
            tmpDict[this.kPCAAppleEventsString] = this.kPCApplianceShowString;
            tmpDict[this.kPCAiTunesRadioString] = this.kPCApplianceShowString;
            tmpDict[this.kPCAESPNString] = this.kPCApplianceShowString;
            tmpDict[this.kPCAMLBString] = this.kPCApplianceShowString;
            tmpDict[this.kPCANBAString] = this.kPCApplianceShowString;
            tmpDict[this.kPCANHLString] = this.kPCApplianceShowString;
            tmpDict[this.kPCASkyNewsString] = this.kPCApplianceShowString;
            tmpDict[this.kPCATrailersString] = this.kPCApplianceShowString;
            tmpDict[this.kPCAYouTubeString] = this.kPCApplianceShowString;
            tmpDict[this.kPCAVimeoString] = this.kPCApplianceShowString;
            tmpDict[this.kPCAQelloString] = this.kPCApplianceShowString;
            tmpDict[this.kPCACrunchyrollString] = this.kPCApplianceShowString;
            tmpDict[this.kPCAPodcastsString] = this.kPCApplianceShowString;
            tmpDict[this.kPCARadioString] = this.kPCApplianceShowString;
            tmpDict[this.kPCAFlickrString] = this.kPCApplianceShowString;
            tmpDict[this.kPCAWSJString] = this.kPCApplianceShowString;
            return(tmpDict);
        }
    }
    restrictions.pciCloudPhotosApplianceMenuItemsAndDefaultValues = function pciCloudPhotosApplianceMenuItemsAndDefaultValues() {
        if (this._passcodeEnabled) {
            var tmpDict = {};
            tmpDict[this.kPCAICPiCloudPhotosString] = this.kPCApplianceAskString;
            tmpDict[this.kPCAICPSharedAlbumInvitationsString] = this.kPCApplianceShowString;
            return(tmpDict);
        }
        else {
            var tmpDict = {};
            tmpDict[this.kPCAICPiCloudPhotosString] = this.kPCApplianceShowString;
            tmpDict[this.kPCAICPSharedAlbumInvitationsString] = this.kPCApplianceShowString;
            return(tmpDict);
        }
    }

    // probably will not use toggleMenuItemsAndValues because access to this is special
    // depending on section
    restrictions.toggleMenuItemsAndValues = undefined;
    restrictions.setToggleMenuItemsAndValues = function setToggleMenuItemsAndValues() {
        this.toggleMenuItemsAndValues = {};
    }
    restrictions.setToggleMenuItemsAndValues();

    // probably will not use menuItemsDefaultValues because access to this is special
    // depending on section
    restrictions.menuItemsDefaultValues = undefined;
    restrictions.setMenuItemsDefaultValues = function setMenuItemsDefaultValues() {
        this.menuItemsDefaultValues = {};
    }
    restrictions.setMenuItemsDefaultValues();

    restrictions.menuItemsNavigation = undefined;
    restrictions.setMenuItemsNavigation = function setMenuItemsNavigation() {
        this.menuItemsNavigation = {};
        if (this._passcodeEnabled) {
            this.menuItemsNavigation[this.kPCTurnOffString] = [
                {"action":"up", "result":"noop"},
                {"action":"left", "result":"noop"},
                {"action":"right", "result":"noop"},
                {"action":"playpause", "result":"noop"},
                {"action":"down", "result":"next"}
            ];
            this.menuItemsNavigation[this.kPCChangePinString] = [
                {"action":"up", "result":"previous"},
                {"action":"left", "result":"noop"},
                {"action":"right", "result":"noop"},
                {"action":"playpause", "result":"noop"},
                {"action":"down", "result":"next"}
            ];
        }
        else {
            this.menuItemsNavigation[this.kPCTurnOnString] = [
                {"action":"up", "result":"noop"},
                {"action":"left", "result":"noop"},
                {"action":"right", "result":"noop"},
                {"action":"playpause", "result":"noop"},
                {"action":"down", "result":"next"}
            ];
        }

        this.menuItemsNavigation[this.kPCPurchaseRentalString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kPCRatingsCountryString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kPCMovieRatingString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kPCTVShowRatingString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kPCExplicitMusicPodcastString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];

        this.menuItemsNavigation[this.kPCAMusicString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kPCANetflixString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kPCAHuluPlusString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kPCAHBOGOString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kPCAAppleEventsString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kPCAiTunesRadioString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kPCAESPNString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kPCAMLBString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kPCANBAString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kPCANHLString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kPCASkyNewsString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kPCATrailersString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kPCAYouTubeString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kPCAVimeoString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kPCAQelloString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kPCACrunchyrollString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kPCAPodcastsString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kPCARadioString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kPCAiCloudPhotosString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kPCAFlickrString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kPCAWSJString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];

        this.menuItemsNavigation[this.kPCAirPlaySettingsString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kPCConferenceRoomDisplayString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"noop"}
        ];
    }
    restrictions.setMenuItemsNavigation();

    // overriding appMenu(), and goTo() methods from base ATVAApp()
    restrictions.appMenu = function appMenu() {
        if ( ! this._appMenu ) {
            this._appMenu = new ATVAPageList(this._title);
        }
        return( this._appMenu );
    }

    restrictions.goTo = function goTo() {
        // Indexes are not saved when we go back to the Main Menu
        this.appMenu().resetList();
        if (general.goToAndSelect(this._title)) {
            return(this.fromMenu(true));
        }
        UIALogger.logError(this._objectName + ".goTo(): failed to get to " + this._title);
        return(undefined);
    }

    restrictions.isParentalControlsOff = function isParentalControlsOff() {
        var turnOnElement = this.appMenu().elementForName(this.kPCTurnOnString, 0, 0, 0)
        if ( ! turnOnElement) {
            return(false);
        }
        return(true);
    }

    restrictions.isParentalControlsOn = function isParentalControlsOn() {
        var turnOffElement = this.appMenu().elementForName(this.kPCTurnOffString, 0, 0, 0)
        if ( ! turnOffElement) {
            return(false);
        }
        return(true);
    }

    restrictions.enterPinInfo = function enterPinInfo(menuTitle, pin, parentMenu) {
        var menu = new ATVAPagePasscode(menuTitle);

        if (parentMenu) {
            var pages = new Array(menu, parentMenu);

            if ( ! ATVAPage.waitForOneOfThesePages(pages, 5, 300)) {
                UIALogger.logError(this._objectName + ".enterPinInfo(): either parent menu or passcode menu not found");
                return (false);
            }

            if (parentMenu.isPageDisplayed()) {
                // passcode was not needed
                return(true);
            }
        }

        if ( ! menu.waitForPage()) {
            UIALogger.logError(this._objectName + ".enterPinInfo(): failed to waiting for menu");
            return(false);
        }
        if ( ! menu.enterPasscodeString(pin)) {
            UIALogger.logError(this._objectName + ".enterPinInfo(): failed entering pin");
            return(false);
        }
        if ( ! menu.submit()) {
            UIALogger.logError(this._objectName + ".enterPinInfo(): failed on submit");
            return(false);
        }
        return(true);
    }

    restrictions.pinConfirm = function pinConfirm(menuTitle, buttonName) {
        var passcodeConfirmedMenu = new ATVAPage(menuTitle);
        if ( ! passcodeConfirmedMenu.waitForPage()) {
            UIALogger.logError(this._objectName + ".pinConfirm(): cannot get to passcode confirmed menu");
            return(false);
        }
        if ( ! passcodeConfirmedMenu.moveToItemWithNameAndSelect(buttonName)) {
            UIALogger.logError(this._objectName + ".pinConfirm(): cannot get to select " + buttonName + " on passcode confirmed menu");
            return(false);
        }
        return(true);
    }

    restrictions.turnParentalControlsOn = function turnParentalControlsOn(pin) {
        if (this.isParentalControlsOn()) {
            // Already on
            return(true);
        }

        if ( ! this.appMenu().moveToItemWithNameAndSelect(this.kPCTurnOnString)) {
            UIALogger.logError(this._objectName + ".turnParentalControlsOn(): failed to get to turn on item");
            return(false);
        }

        if ( ! this.enterPinInfo("Set Passcode", pin)) {
            UIALogger.logError(this._objectName + ".turnParentalControlsOn(): failed to enter pin");
            return(false);
        }

        if ( ! this.enterPinInfo("Confirm Passcode", pin)) {
            UIALogger.logError(this._objectName + ".turnParentalControlsOn(): failed to confirm pin");
            return(false);
        }

        if ( ! this.pinConfirm("Passcode Confirmed", "OK")) {
            UIALogger.logError(this._objectName + ".turnParentalControlsOn(): cannot confirmed passcode");
            return(false);
        }

        // After the connection, back on Parental Controls menu
        this.appMenu().resetList();
        if ( ! this.appMenu().waitForPage()) {
            UIALogger.logError(this._objectName + ".turnParentalControlsOn(): cannot get back to Parental Controls menu");
            return(false);
        }

        if (this.isParentalControlsOn()) {
            return(true);
        }
        UIALogger.logError(this._objectName + ".turnParentalControlsOn(): parental controls not turned on");
        return(false);
    }

    restrictions.turnParentalControlsOff = function turnParentalControlsOff(pin) {
        if (this.isParentalControlsOff()) {
            // Already off
            return(true);
        }

        if ( ! this.appMenu().moveToItemWithNameAndSelect(this.kPCTurnOffString)) {
            UIALogger.logError(this._objectName + ".turnParentalControlsOff(): failed to get to turn off item");
            return(false);
        }

        if ( ! this.enterPinInfo("Enter Passcode", pin, this.appMenu())) {
            UIALogger.logError(this._objectName + ".turnParentalControlsOff(): failed to enter pin");
            return(false);
        }

        // After the connection, back on Parental Controls menu
        this.appMenu().resetList();
        if ( ! this.appMenu().waitForPage()) {
            UIALogger.logError(this._objectName + ".turnParentalControlsOff(): cannot get back to Parental Controls menu");
            return(false);
        }

        if (this.isParentalControlsOff()) {
            return(true);
        }
        UIALogger.logError(this._objectName + ".turnParentalControlsOff(): parental controls not turned off");
        return(false);
    }

    restrictions.changeParentalControlsPin = function changeParentalControlsPin(oldPin, newPin) {
        if (this.isParentalControlsOff()) {
            UIALogger.logError(this._objectName + ".changeParentalControlsPin(): cannot change passcode because restrictions is not on");
            return(false);
        }

        if ( ! this.appMenu().moveToItemWithNameAndSelect(this.kPCChangePinString)) {
            UIALogger.logError(this._objectName + ".changeParentalControlsPin(): failed to select change passcode");
            return(false);
        }

        var oldPasscodeMenu = new ATVAPagePasscode("Enter Passcode");

        if ( ! this.enterPinInfo("New Passcode", newPin, oldPasscodeMenu)) {
            UIALogger.logError(this._objectName + ".changeParentalControlsPin(): failed to enter new pin");
            return(false);
        }
        if (oldPasscodeMenu.isPageDisplayed()) {
            // needed to enter passcode first.
            if ( ! this.enterPinInfo("Enter Passcode", oldPin)) {
                UIALogger.logError(this._objectName + ".changeParentalControlsPin(): failed to enter old pin");
                return(false);
            }
            if ( ! this.enterPinInfo("New Passcode", newPin)) {
                UIALogger.logError(this._objectName + ".changeParentalControlsPin(): failed to enter new pin");
                return(false);
            }
        }

        if ( ! this.enterPinInfo("Confirm Passcode", newPin)) {
            UIALogger.logError(this._objectName + ".changeParentalControlsPin(): failed to confirm pin");
            return(false);
        }

        if ( ! this.pinConfirm("Passcode Confirmed", "OK")) {
            UIALogger.logError(this._objectName + ".changeParentalControlsPin(): cannot confirmed passcode");
            return(false);
        }

        // After the connection, back on Parental Controls menu
        this.appMenu().resetList();
        if ( ! this.appMenu().waitForPage()) {
            UIALogger.logError(this._objectName + ".changeParentalControlsPin(): cannot get back to Parental Controls menu");
            return(false);
        }

        if (this.isParentalControlsOn()) {
            return(true);
        }
        UIALogger.logError(this._objectName + ".changeParentalControlsPin(): parental controls not turned on");
        return(false);
    }

    general.setValueForParentalControlsToggle = function setValueForParentalControlsToggle(menu, pin, menuItem, value) {
        if (this.pcToggleMenuItemsAndValues[menuItem] == undefined) {
            UIALogger.logError(this._objectName + ".setValueForParentalControlsToggle(): invalid toggle menu item \"" + menuItem + "\"");
            return(false);
        }

        if (this.pcToggleMenuItemsAndValues[menuItem].indexOf(value) == -1) {
            UIALogger.logError(this._objectName + ".setValueForParentalControlsToggle(): value is not in the possible values \"" + value + "\" for \"" + menuItem + "\"");
            return(false);
        }

        if ( ! menu) {
            UIALogger.logError(this._objectName + ".setValueForParentalControlsToggle(): no menu given, cannot continue");
            return(false);
        }

        var focus = menu.moveToItemWithName(menuItem);
        if ( ! focus) {
            UIALogger.logError(this._objectName + ".setValueForParentalControlsToggle(): failed to get to menu item " + menuItem);
            return(false);
        }
        if (focus.value() == value) {
            // already set to value
            return(true);
        }
        menu.selectIntoPage();

        if ( ! this.enterPinInfo("Enter Passcode", pin, menu)) {
            UIALogger.logError(this._objectName + ".setValueForParentalControlsToggle(): failed to enter pin");
            return(false);
        }

        if (menu.toggleItem(menuItem, value, this.pcToggleMenuItemsAndValues[menuItem])) {
            return(true);
        }
        else {
            UIALogger.logError(this._objectName + ".setValueForParentalControlsToggle(): failed");
            return(false);
        }
    }

    general.setMultipleValuesForParentalControlsToggles = function setMultipleValuesForParentalControlsToggles(menu, pin, items, values) {
        if (items.length != values.length) {
            UIALogger.logError(this._objectName + ".setMultipleValuesForParentalControlsToggles(): number of items and values do not match");
            return(false);
        }

        for (var i = 0; i < items.length; ++i) {
            if ( ! this.setValueForParentalControlsToggle(menu, pin, items[i], values[i])) {
                UIALogger.logError(this._objectName + ".setMultipleValuesForParentalControlsToggles(): failed to set " + items[i] + " to " + values[i]);
                return(false);
            }
        }
        return(true);
    }

    general.getValueForParentalControlsToggle = function getValueForParentalControlsToggle(menu, menuItem) {
        if (this.pcToggleMenuItemsAndValues[menuItem] == undefined) {
            UIALogger.logError(this._objectName + ".getValueForParentalControlsToggle(): invalid toggle menu item \"" + menuItem + "\"");
            return(undefined);
        }

        if ( ! menu) {
            UIALogger.logError(this._objectName + ".getValueForParentalControlsToggle(): no menu given, cannot continue");
            return(undefined);
        }

        var focus = menu.moveToItemWithName(menuItem);

        if ( ! focus) {
            UIALogger.logError(this._objectName + ".getValueForParentalControlsToggle(): failed to get to focus for " + menuItem);
            return(undefined);
        }

        return(focus.value());
    }
}
