
#import "Remotes.js"

/**
 *       Function: remotesTest_verifyMenuContents
 *           Verifies that expect menu items.
 *   
 *  \return 1 success, otherwise 0
 **/

function remotesTest_verifyMenuContents() {
    if ( ! remotes.goTo()) {
        this.testError = "Fail to get to Settings>General>Remotes";
        return this.testResult = 0;
    }

    if ( ! remotes.appMenu().verifyMenuContents(remotes.menuItems) ) {
        this.testError = "Menu contents verification failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: remotesTest_verifyMenuNavigation
 *           Verifies the basic navigation of the page.
 *   
 *  \return 1 success, otherwise 0
 **/

function remotesTest_verifyMenuNavigation() {
    if ( ! remotes.goTo()) {
        this.testError = "Fail to get to Settings>General>Remotes";
        return this.testResult = 0;
    }

    if ( ! remotes.appMenu().verifyMenuNavigation(remotes.menuItems, remotes.menuItemsNavigation) ) {
        this.testError = "Menu navigation verification failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}
