
#import "./General.js"

// --------------------------------------------------------------------------------
//      Object: remotes
//              remotes is an ATVAApp object for interacting with the
//              Settings/General/Remotes appliance on Apple TV.
// --------------------------------------------------------------------------------

if (typeof remotes == 'undefined') {
    remotes = new ATVAApp("Remotes");
}

if (typeof remotes != 'undefined') {
    remotes._objectName = "remotes";

    remotes.kPairAppleRemote = "Pair Apple Remote";
    remotes.kUnPairAppleRemote = "Unpair Apple Remote";
    remotes.kRemoteApp = "Remote App";
    remotes.kLearnRemote = "Learn Remote";
    
    remotes.menuItems = [
        remotes.kPairAppleRemote,
        remotes.kRemoteApp,
        remotes.kLearnRemote
    ];

    remotes.menuItemsNavigation = undefined;
    remotes.setMenuItemsNavigation = function setMenuItemsNavigation() {
        this.menuItemsNavigation = {};
        this.menuItemsNavigation[this.kPairAppleRemote] = [
            {"action":"up", "result":"noop"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"},
        ];
        this.menuItemsNavigation[this.kRemoteApp] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"},
        ];
        this.menuItemsNavigation[this.kLearnRemote] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"noop"},
        ];
    }
    remotes.setMenuItemsNavigation();

    remotes.appMenu = function appMenu() {
        if ( ! this._appMenu ) {
            this._appMenu = new ATVAPageList(this._title);
            this._appMenu.setListScrolls(false);
        }
        return( this._appMenu );
    }

    remotes.goTo = function goTo() {
        // Indexes are not saved when we go back to the Main Menu
        this.appMenu().resetList();
        if (general.goToAndSelect(this._title)) {
            return(this.fromMenu());
        }
        UIALogger.logError(this._objectName + ".goTo(): failed to get to " + this._title);
        return(undefined);
    }
}
