
#import "General.js"

/**
 *       Function: generalTest_verifyMenuContents
 *           Verifies that expect menu items.
 *   
 *  \return 1 success, otherwise 0
 **/

function generalTest_verifyMenuContents() {
    if ( ! general.goTo()) {
        this.testError = "Fail to get to Settings>General";
        return this.testResult = 0;
    }

    if ( ! general.appMenu().verifyMenuContents(general.menuItems) ) {
        this.testError = "Menu contents verification failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: generalTest_verifyMenuNavigation
 *           Verifies the basic navigation of the page.
 *   
 *  \return 1 success, otherwise 0
 **/

function generalTest_verifyMenuNavigation() {
    if ( ! general.goTo()) {
        this.testError = "Fail to get to Settings>General";
        return this.testResult = 0;
    }

    if ( ! general.appMenu().verifyMenuNavigation(general.menuItems, general.menuItemsNavigation) ) {
        this.testError = "Menu navigation verification failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: generalTest_verifyDefaultValues
 *           Verifies the default values for Settings>Audio & Video. Assumes that the defaults
 *           are currently set.
 *   
 *  \return 1 success, otherwise 0
 **/

function generalTest_verifyDefaultValues() {
    if ( ! general.goTo()) {
        this.testError = "Fail to get to Settings>General";
        return this.testResult = 0;
    }

    if ( ! general.appMenu().verifyDefaultValues(general.menuItemsWithValues, general.menuItemsDefaultValues) ) {
        this.testError = "Menu default value verification failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: generalTest_verifyToggleValues
 *           Verify that toggle values can be changed to the expected values.
 *   
 *  \return 1 success, otherwise 0
 **/

function generalTest_verifyToggleValues() {
    if ( ! general.goTo()) {
        this.testError = "Fail to get to Settings>General";
        return this.testResult = 0;
    }

    if ( ! general.appMenu().verifyToggleValues(general.toggleMenuItemsAndValues, []) ) {
        this.testError = "Menu toggle value verification failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: generalTest_nameVerifyMenuContents
 *           Verifies that expect menu items.
 *   
 *  \return 1 success, otherwise 0
 **/

function generalTest_nameVerifyMenuContents() {
    if ( ! general.goTo()) {
        this.testError = "Fail to get to Settings>General";
        return this.testResult = 0;
    }

    if ( ! general.nameVerifyMenuContent() ) {
        this.testError = "Menu contents verification failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: generalTest_nameVerifyMenuNavigation
 *           Verifies the basic navigation of the page.
 *   
 *  \return 1 success, otherwise 0
 **/

function generalTest_nameVerifyMenuNavigation() {
    if ( ! general.goTo()) {
        this.testError = "Fail to get to Settings>General";
        return this.testResult = 0;
    }

    if ( ! general.nameVerifyMenuNavigation() ) {
        this.testError = "Menu navigation verification failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: generalTest_setMachineName
 *           Go to Settings>General>Name and set the machine name.
 *   
 *  \param machineName (string) - machine name
 *   
 *  \return 1 if successfully signed in, otherwise 0
 **/

function generalTest_setMachineName() {
    if (this.argv.length < 1) {
        this.testError = "Machine Name not specified.";
        return this.testResult = 0;
    }
    var machineName = this.argv[0];

    if ( ! general.goToAndSetValueForName(machineName)) {
        this.testError = "Fail to set machine name";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: generalTest_setMachineNameWithDefaultValues
 *           Cycle through default values. For eache go to Settings>General>Name and
 *           set the machine name.
 *   
 *  \return 1 if successfully signed in, otherwise 0
 **/

function generalTest_setMachineNameWithDefaultValues() {
    // First, get the current value, will reset to this at the end
    UIALogger.logMessage("Getting current name");
    var currentMachineName = general.goToAndGetValueForName();
    if ( ! currentMachineName) {
        this.testError = "Fail to get current machine name";
        return this.testResult = 0;
    }
    UIALogger.logMessage("Current name " + currentMachineName);
    for (var i = 0; i < general.nameDefaultValues.length; ++i) {
        UIALogger.logMessage("Setting name to " + general.nameDefaultValues[i]);
        if ( ! general.goToAndSetValueForName(general.nameDefaultValues[i])) {
            this.testError = "Fail to set machine name to " + general.nameDefaultValues[i];
            return this.testResult = 0;
        }
    }
    UIALogger.logMessage("Setting name back to " + currentMachineName);
    if ( ! general.goToAndSetValueForName(currentMachineName)) {
        this.testError = "Fail to set machine name back to " + currentMachineName;
        return this.testResult = 0;
    }
    return this.testResult = 1;
}






/**
 *       Function: generalTest_configureEthernetToAutomatic
 *           Go to Settings>General>Network>Ethernet and set to DHCP.
 *   
 *  \return 1 if successfully signed in, otherwise 0
 **/

function generalTest_configureEthernetToAutomatic() {
    if ( ! general.configureEthernet(general.fromNetworkGoToEthernetMenu(general.goToNetworkMenu()), "Automatic")) {
        this.testError = "Fail to configure ethernet to DHCP";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: generalTest_configureEthernetToManual
 *           Go to Settings>General>Network>Ethernet and set ip information manually.
 *   
 *  \param ipAddress (string) - IPv6 address
 *  \param subnetMask (string) - IPv6 subnet mask
 *  \param routerGateway (string) - IPv6 gateway
 *  \param dnsAddress (string) - IPv6 DNS address
 *
 *  \return 1 if successfully signed in, otherwise 0
 **/

function generalTest_configureEthernetToManual() {
    if (this.argv.length < 4) {
        this.testError = "arguements not specified.";
        return this.testResult = 0;
    }
    var ipAddress = this.argv[0];
    var subnetMask = this.argv[1];
    var routerGateway = this.argv[2];
    var dnsAddress = this.argv[3];
    if ( ! general.configureEthernet(general.fromNetworkGoToEthernetMenu(general.goToNetworkMenu()), "Manual", ipAddress, subnetMask, routerGateway, dnsAddress)) {
        this.testError = "Fail to configure ethernet manually";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: generalTest_configureEthernetDNSToAutomatic
 *           Go to Settings>General>Network>Ethernet and set DNS to DHCP.
 *   
 *  \return 1 if successfully signed in, otherwise 0
 **/

function generalTest_configureEthernetDNSToAutomatic() {
    if ( ! general.configureDNS(general.fromNetworkGoToEthernetMenu(general.goToNetworkMenu()), "Automatic")) {
        this.testError = "Fail to configure DNS to DHCP";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: generalTest_configureEthernetDNSToManual
 *           Go to Settings>General>Network>Ethernet and set DNS information manually.
 *   
 *  \param dnsAddress (string) - IPv6 DNS address
 *
 *  \return 1 if successfully signed in, otherwise 0
 **/

function generalTest_configureEthernetDNSToManual() {
    if (this.argv.length < 1) {
        this.testError = "arguements not specified.";
        return this.testResult = 0;
    }
    var dnsAddress = this.argv[0];
    if ( ! general.configureDNS(general.fromNetworkGoToEthernetMenu(general.goToNetworkMenu()), "Manual", dnsAddress)) {
        this.testError = "Fail to configure DNS manually";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: generalTest_joinWiFiNetwork
 *           Go to Settings>General>Network>WiFi and join a network.
 *   
 *  \param ssid (string) - WiFi SSID
 *  \param password (string) - WiFi Password
 *
 *  \return 1 if successfully signed in, otherwise 0
 **/

function generalTest_joinWiFiNetwork() {
    if (this.argv.length < 2) {
        this.testError = "arguments not specified.";
        return this.testResult = 0;
    }
    var ssid = this.argv[0];
    var password = this.argv[1];
    if (password == "") {
        // no password needed (AppleWiFi)
        password = undefined;
    }
    if ( ! general.fromNetworkSelectWiFiNetwork(general.goToNetworkMenu(), ssid, password)) {
        this.testError = "Fail to join WiFi network";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: generalTest_forgetWiFiNetwork
 *           Go to Settings>General>Network>WiFi and forget a network.
 *   
 *  \param ssid (string) - WiFi SSID
 *  \param password (string) - WiFi Password
 *
 *  \return 1 if successfully signed in, otherwise 0
 **/

function generalTest_forgetWiFiNetwork() {
    if (this.argv.length < 2) {
        this.testError = "arguments not specified.";
        return this.testResult = 0;
    }
    var ssid = this.argv[0];
    var password = this.argv[1];
    if (password == "") {
        // no password needed (AppleWiFi)
        password = undefined;
    }
    if ( ! general.forgetWiFiNetwork(general.goToNetworkMenu(), ssid, password)) {
        this.testError = "Fail to forget WiFi network";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: generalTest_configureWiFiToAutomatic
 *           Go to Settings>General>Network>WiFi and set to DHCP.
 *   
 *  \param ssid (string) - WiFi SSID
 *  \param password (string) - WiFi Password
 *
 *  \return 1 if successfully signed in, otherwise 0
 **/

function generalTest_configureWiFiToAutomatic() {
    if (this.argv.length < 2) {
        this.testError = "arguments not specified.";
        return this.testResult = 0;
    }
    var ssid = this.argv[0];
    var password = this.argv[1];
    if (password == "") {
        // no password needed (AppleWiFi)
        password = undefined;
    }
    if ( ! general.configureEthernet(general.fromNetworkGoToWiFiMenu(general.goToNetworkMenu(), ssid, password), "Automatic")) {
        this.testError = "Fail to configure WiFi to DHCP";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: generalTest_configureWiFiToManual
 *           Go to Settings>General>Network>WiFi and set ip information manually.
 *   
 *  \param ssid (string) - WiFi SSID
 *  \param password (string) - WiFi Password
 *  \param ipAddress (string) - IPv6 address
 *  \param subnetMask (string) - IPv6 subnet mask
 *  \param routerGateway (string) - IPv6 gateway
 *  \param dnsAddress (string) - IPv6 DNS address
 *
 *  \return 1 if successfully signed in, otherwise 0
 **/

function generalTest_configureWiFiToManual() {
    if (this.argv.length < 6) {
        this.testError = "arguements not specified.";
        return this.testResult = 0;
    }
    var ssid = this.argv[0];
    var password = this.argv[1];
    if (password == "") {
        // no password needed (AppleWiFi)
        password = undefined;
    }
    var ipAddress = this.argv[2];
    var subnetMask = this.argv[3];
    var routerGateway = this.argv[4];
    var dnsAddress = this.argv[5];
    if ( ! general.configureEthernet(general.fromNetworkGoToWiFiMenu(general.goToNetworkMenu(), ssid, password), "Manual", ipAddress, subnetMask, routerGateway, dnsAddress)) {
        this.testError = "Fail to configure WiFi manually";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: generalTest_configureWiFiDNSToAutomatic
 *           Go to Settings>General>Network>WiFi and set DNS to DHCP.
 *   
 *  \param ssid (string) - WiFi SSID
 *  \param password (string) - WiFi Password
 *
 *  \return 1 if successfully signed in, otherwise 0
 **/

function generalTest_configureWiFiDNSToAutomatic() {
    if (this.argv.length < 2) {
        this.testError = "arguments not specified.";
        return this.testResult = 0;
    }
    var ssid = this.argv[0];
    var password = this.argv[1];
    if (password == "") {
        // no password needed (AppleWiFi)
        password = undefined;
    }
    if ( ! general.configureDNS(general.fromNetworkGoToWiFiMenu(general.goToNetworkMenu(), ssid, password), "Automatic")) {
        this.testError = "Fail to configure WiFi to DHCP";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: generalTest_configureWiFiDNSToManual
 *           Go to Settings>General>Network>WiFi and set DNS manually.
 *   
 *  \param ssid (string) - WiFi SSID
 *  \param password (string) - WiFi Password
 *  \param dnsAddress (string) - IPv6 DNS address
 *
 *  \return 1 if successfully signed in, otherwise 0
 **/

function generalTest_configureWiFiDNSToManual() {
    if (this.argv.length < 3) {
        this.testError = "arguements not specified.";
        return this.testResult = 0;
    }
    var ssid = this.argv[0];
    var password = this.argv[1];
    if (password == "") {
        // no password needed (AppleWiFi)
        password = undefined;
    }
    var dnsAddress = this.argv[2];
    if ( ! general.configureDNS(general.fromNetworkGoToWiFiMenu(general.goToNetworkMenu(), ssid, password), "Manual", dnsAddress)) {
        this.testError = "Fail to configure WiFi manually";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: generalTest_configureTimeZoneToAutomatic
 *           Go to Settings>General>Time Zone and set to Automatic
 *
 *  \return 1 if successfully signed in, otherwise 0
 **/

function generalTest_configureTimeZoneToAutomatic() {
    if ( ! general.setTimeZoneSetAutomatically(general.goToTimeZoneMenu(), true)) {
        this.testError = "Fail to set Time Zone to Automatic";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: generalTest_configureTimeZoneToManual
 *           Go to Settings>General>Time Zone and set to Automatic
 *
 *  \return 1 if successfully signed in, otherwise 0
 **/

function generalTest_configureTimeZoneToManual() {
    if ( ! general.setTimeZoneSetAutomatically(general.goToTimeZoneMenu(), false)) {
        this.testError = "Fail to set Time Zone to Manual";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: generalTest_setTimeZoneCity
 *           Go to Settings>General>Time Zone and set city
 *
 *  \param shortCityName (string) - short city name "Cupertino"
 *  \param longCityName (string) - long city name "Cupertino, U.S.A."
 *
 *  \return 1 if successfully signed in, otherwise 0
 **/

function generalTest_setTimeZoneCity() {
    if (this.argv.length < 2) {
        this.testError = "Arguments are specified";
        return this.testResult = 0;
    }
    var shortCityName = this.argv[0];
    var longCityName = this.argv[1];

    if ( ! general.setTimeZone(general.goToTimeZoneMenu(), shortCityName, longCityName)) {
        this.testError = "Fail to set Time Zone City";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: generalTest_setSleep
 *           Go to Settings>General>Sleep and set the machine name.
 *   
 *  \param sleepTime (string) - time to sleep after
 *   
 *  \return 1 if successfully signed in, otherwise 0
 **/

function generalTest_setSleep() {
    if (this.argv.length < 1) {
        this.testError = "Sleep after time not specified.";
        return this.testResult = 0;
    }
    var sleepTime = this.argv[0];

    UIALogger.logMessage("Trying to set sleep after to " + sleepTime);
    if ( ! general.goToAndSetValueForToggle(general.kSleepAfterString, sleepTime)) {
        this.testError = "Failed to set sleep after to " + sleepTime;
        return this.testResult = 0;
    }

    return this.testResult = 1;
}

/**
 *       Function: generalTest_setSendData
 *           Go to Settings>General>Send Data to Apple and turn on or off
 *   
 *  \param sendData (string) - (True) turn on, (False) turn off
 *   
 *  \return 1 if successfully signed in, otherwise 0
 **/

function generalTest_setSendData() {
    if (this.argv.length < 1) {
        this.testError = "Arguments are specified";
        return this.testResult = 0;
    }
    var sendData = false;
    if (this.argv[0].toUpperCase() == "TRUE") {
        sendData = true;
    }
    if ( ! general.goToAndSetSendData(sendData)) {
        this.testError = "Fail to set send data";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: generalTest_languageVerifyMenuContents
 *           Verifies that expect menu items.
 *   
 *  \return 1 success, otherwise 0
 **/

function generalTest_languageVerifyMenuContents() {
    if ( ! general.goToLanguageMenu()) {
        this.testError = "Fail to get to Settings>General>Language";
        return this.testResult = 0;
    }

    if ( ! general.languageMenu().verifyMenuContents(general.languagesMenuItems) ) {
        // get out of language menu
        general.languageMenu().menuOutOfPage();

        this.testError = "Menu contents verification failed";
        return this.testResult = 0;
    }
    else {
        // get out of language menu
        general.languageMenu().menuOutOfPage();

        return this.testResult = 1;
    }
}

/**
 *       Function: generalTest_regionFormatVerifyMenuContents
 *           Verifies that expect menu items.
 *   
 *  \return 1 success, otherwise 0
 **/

function generalTest_regionFormatVerifyMenuContents() {
    if ( ! general.goToRegionFormatMenu()) {
        this.testError = "Fail to get to Settings>General>Region Format";
        return this.testResult = 0;
    }

    if ( ! general.regionFormatMenu().verifyMenuContents(general.regionFormatMenuItems) ) {
        // get out of Region Format menu
        general.regionFormatMenu().menuOutOfPage();

        this.testError = "Menu contents verification failed";
        return this.testResult = 0;
    }
    else {
        // get out of Region Format menu
        general.regionFormatMenu().menuOutOfPage();

        return this.testResult = 1;
    }
}
