
#import "../Settings.js"

// --------------------------------------------------------------------------------
//      Object: general
//              general is an ATVAApp object for interacting with the
//              General appliance on Apple TV.
// --------------------------------------------------------------------------------

if (typeof general == 'undefined') {
    general = new ATVAApp("General");
}

if (typeof general != 'undefined') {
    general._objectName = "general";

    general.kAboutString = "About";
    general.kNameString = "Name";
    general.kNetworkString = "Network";
    general.kRestrictionsString = "Restrictions";
    general.kRemotesString = "Remotes";
    general.kBluetoothString = "Bluetooth";
    general.kSoftwareUpdatesString = "Software Updates";
    general.kTimeZoneString = "Time Zone";
    general.kSleepAfterString = "Sleep After";
    general.kSleepAfter15mString = "15 minutes";
    general.kSleepAfter30mString = "30 minutes";
    general.kSleepAfter1hString = "1 hour";
    general.kSleepAfter5hString = "5 hours";
    general.kSleepAfter10hString = "10 hours";
    general.kSleepAfterNeverString = "Never";
    general.kSendDatatoAppleString = "Send Data to Apple";
    general.kSendDatatoAppleNoString = "No";
    general.kSendDatatoAppleYesString = "Yes";
    general.kLanguageString = "Language";
    general.kRegionFormatString = "Region Format";
    general.kAccessibilityString = "Accessibility";
    general.kTroubleshootingString = "Troubleshooting";
    general.kLegalString = "Legal";
    general.kResetString = "Reset";
    general.kRestartString = "Restart";
    general.kFeatureEnablerString = "Feature Enabler";
    
    general.menuItems = [
        general.kAboutString,
        general.kNameString,
        general.kNetworkString,
        general.kRestrictionsString,
        general.kRemotesString,
        general.kBluetoothString,
        general.kSoftwareUpdatesString,
        general.kTimeZoneString,
        general.kSleepAfterString,
        general.kSendDatatoAppleString,
        general.kLanguageString,
        general.kRegionFormatString,
        general.kAccessibilityString,
        general.kTroubleshootingString,
        general.kLegalString,
        general.kResetString,
        general.kRestartString,
        general.kFeatureEnablerString
    ];
    general.menuItemsWithValues = [
        general.kNameString,
        general.kSleepAfterString,
        general.kSendDatatoAppleString,
    ];

    general.toggleMenuItemsAndValues = undefined;
    general.setToggleMenuItemsAndValues = function setToggleMenuItemsAndValues() {
        this.toggleMenuItemsAndValues = {};
        this.toggleMenuItemsAndValues[this.kSleepAfterString] = [this.kSleepAfter15mString, this.kSleepAfter30mString, this.kSleepAfter1hString, this.kSleepAfter5hString, this.kSleepAfter10hString, this.kSleepAfterNeverString];
    }
    general.setToggleMenuItemsAndValues();

    general.menuItemsDefaultValues = undefined;
    general.setMenuItemsDefaultValues = function setMenuItemsDefaultValues() {
        this.menuItemsDefaultValues = {};
        this.menuItemsDefaultValues[this.kNameString] = "Apple TV";
        this.menuItemsDefaultValues[this.kSleepAfterString] = this.kSleepAfter1hString;
        this.menuItemsDefaultValues[this.kSendDatatoAppleString] = this.kSendDatatoAppleYesString;
    }
    general.setMenuItemsDefaultValues();

    general.menuItemsNavigation = undefined;
    general.setMenuItemsNavigation = function setMenuItemsNavigation() {
        this.menuItemsNavigation = {};
        this.menuItemsNavigation[this.kAboutString] = [
            {"action":"up", "result":"noop"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kNameString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kNetworkString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kRestrictionsString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kRemotesString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kBluetoothString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kSoftwareUpdatesString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kTimeZoneString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kSleepAfterString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        // Right button brings up the Device Diagnostic ID, but Send Data to Apple
        // is still highlighted.
        // TODO: Appear that by bring up Device Diagnostic ID the focus changes to
        //       a something without a name (null). Probably there needs to be an extra
        //       delay here. Taking out for now.
        //    {"action":"right", "result":"noop"},
        this.menuItemsNavigation[this.kSendDatatoAppleString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kLanguageString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kRegionFormatString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kAccessibilityString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kTroubleshootingString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kLegalString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kResetString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kRestartString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.menuItemsNavigation[this.kFeatureEnablerString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"noop"}
        ];
    }
    general.setMenuItemsNavigation();

    // overriding appMenu(), and goTo() methods from base ATVAApp()
    general.appMenu = function appMenu() {
        if ( ! this._appMenu ) {
            this._appMenu = new ATVAPageList(this._title);
        }
        return( this._appMenu );
    }

    general.goTo = function goTo() {
        // Indexes are not saved when we go back to the Main Menu
        this.appMenu().resetList();
        if (settings.goToAndSelect(this._title)) {
            return(this.fromMenu(true));
        }
        UIALogger.logError(this._objectName + ".goTo(): failed to get to " + this._title);
        return(undefined);
    }

    // methods for Name

    general.kNameAppleTVString = "Apple TV";
    general.kNameLivingRoomString = "Living Room";
    general.kNameFamilyRoomString = "Family Room";
    general.kNameBedroomString = "Bedroom";
    general.kNameKitchenString = "Kitchen";
    general.kNameGreatRoomString = "Great Room";
    general.kNameOfficeString = "Office";
    general.kNameCustomString = "Custom…";

    general.nameMenuItems = [
        general.kNameAppleTVString,
        general.kNameLivingRoomString,
        general.kNameFamilyRoomString,
        general.kNameBedroomString,
        general.kNameKitchenString,
        general.kNameGreatRoomString,
        general.kNameOfficeString,
        general.kNameCustomString,
    ];

    general.nameDefaultValues = [
        general.kNameAppleTVString,
        general.kNameLivingRoomString + " " + general.kNameAppleTVString,
        general.kNameFamilyRoomString + " " + general.kNameAppleTVString,
        general.kNameBedroomString + " " + general.kNameAppleTVString,
        general.kNameKitchenString + " " + general.kNameAppleTVString,
        general.kNameGreatRoomString + " " + general.kNameAppleTVString,
        general.kNameOfficeString + " " + general.kNameAppleTVString
    ];

    general.nameMenuItemsNavigation = undefined;
    general.setNameMenuItemsNavigation = function setNameMenuItemsNavigation() {
        this.nameMenuItemsNavigation = {};
        this.nameMenuItemsNavigation[this.kNameAppleTVString] = [
            {"action":"up", "result":"noop"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.nameMenuItemsNavigation[this.kNameLivingRoomString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.nameMenuItemsNavigation[this.kNameFamilyRoomString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.nameMenuItemsNavigation[this.kNameBedroomString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.nameMenuItemsNavigation[this.kNameKitchenString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.nameMenuItemsNavigation[this.kNameGreatRoomString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.nameMenuItemsNavigation[this.kNameOfficeString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"}
        ];
        this.nameMenuItemsNavigation[this.kNameCustomString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"noop"}
        ];
    }
    general.setNameMenuItemsNavigation();

    general.nameVerifyMenuContent = function nameVerifyMenuContent() {
        if ( ! this.appMenu().moveToItemWithNameAndSelect(this.kNameString) ) {
            UIALogger.logError(this._objectName + ".nameVerifyMenuContent(): failed to get to select for " + this.kNameString);
            return(false);
        }

        var nameMenu = new ATVAPageList(this.kNameString);
        nameMenu.setListCenter();
        nameMenu.setListScrolls(false);
        if ( ! nameMenu.waitForPage()) {
            UIALogger.logError(this._objectName + ".nameVerifyMenuContent(): failed to waiting for menu " + this.kNameString);
            return(false);
        }

        var verifyResult = nameMenu.verifyMenuContents(this.nameMenuItems);

        nameMenu.menuOutOfPage();
        if ( ! this.fromMenu() ) {
            UIALogger.logError(this._objectName + ".nameVerifyMenuContent(): failed to get back to " + this.appMenu().title());
        }

        return(verifyResult);
    }

    general.nameVerifyMenuNavigation = function nameVerifyMenuNavigation() {
        if ( ! this.appMenu().moveToItemWithNameAndSelect(this.kNameString) ) {
            UIALogger.logError(this._objectName + ".nameVerifyMenuNavigation(): failed to get to select for " + this.kNameString);
            return(false);
        }

        var nameMenu = new ATVAPageList(this.kNameString);
        nameMenu.setListCenter();
        nameMenu.setListScrolls(false);
        if ( ! nameMenu.waitForPage()) {
            UIALogger.logError(this._objectName + ".nameVerifyMenuNavigation(): failed to waiting for menu " + this.kNameString);
            return(false);
        }

        var verifyResult = nameMenu.verifyMenuNavigation(this.nameMenuItems, this.nameMenuItemsNavigation);

        nameMenu.menuOutOfPage();
        if ( ! this.fromMenu() ) {
            UIALogger.logError(this._objectName + ".nameVerifyMenuNavigation(): failed to get back to " + this.appMenu().title());
        }

        return(verifyResult);
    }

    general.nameSetValue = function nameSetValue(value) {
        var nameElement = this.appMenu().elementForName(this.kNameString, 0, 0, 4);
        if ( ! nameElement) {
            UIALogger.logError(this._objectName + ".nameSetValue(): cannot find menu item " + this.kNameString);
            return(false);
        }

        if (value == nameElement.value()) {
            // nothing to do.
            return(true);
        }

        if ( ! this.appMenu().moveToItemWithNameAndSelect(this.kNameString) ) {
            UIALogger.logError(this._objectName + ".nameSetValue(): failed to get to select for " + this.kNameString);
            return(false);
        }

        var nameMenu = new ATVAPageList(this.kNameString);
        nameMenu.setListCenter();
        nameMenu.setListScrolls(false);
        if ( ! nameMenu.waitForPage()) {
            UIALogger.logError(this._objectName + ".nameSetValue(): failed to waiting for menu " + this.kNameString);
            return(false);
        }

        var nameIndex = this.nameDefaultValues.indexOf(value);
        if (nameIndex > -1) {
            // This is a default name, select the menu item. Notice the menu items do not have 'Apple TV' on them
            if ( ! nameMenu.moveToItemWithNameAndSelect(this.nameMenuItems[nameIndex])) {
                UIALogger.logError(this._objectName + ".nameSetValue(): failed to select " + this.nameMenuItems[nameIndex]);
                return(false);
            }
        }
        else {
            // This is a custom name.
            if ( ! nameMenu.moveToItemWithNameAndSelect(this.kNameCustomString)) {
                UIALogger.logError(this._objectName + ".nameSetValue(): failed to select " + this.kNameCustomString);
                return(false);
            }

            // enter name
            var name_kb = new ATVAPageAccount(this.kNameString);
            if ( ! name_kb.waitForPage()) {
                UIALogger.logError(this._objectName + ".nameSetValue(): failed to waiting for keyboard " + this.kNameString);
                return (false);
            }
            if ( ! name_kb.enterString(value)) {
                UIALogger.logError(this._objectName + ".nameSetValue(): failed to enter string " + value);
                return (false);
            }
            if ( ! name_kb.submit()) {
                UIALogger.logError(this._objectName + ".nameSetValue(): failed to select submit");
                return (false);
            }
        }

        // back on General Menu, reload and verify name changed
        this.appMenu().resetList();
        if ( ! this.fromMenu()) {
            UIALogger.logError(this._objectName + ".nameSetValue(): failed to return to General menu");
            return(false);
        }

        var nameElement = this.appMenu().elementForName(this.kNameString, 0, 0, 4);
        if ( ! nameElement) {
            UIALogger.logError(this._objectName + ".nameSetValue(): cannot find menu item " + this.kNameString);
            return(false);
        }

        if (value == nameElement.value()) {
            // nothing to do.
            return(true);
        }
        // failed to set name
        UIALogger.logError(this._objectName + ".nameSetValue(): failed to set name " + value);
        return(false);
    }

    general.goToAndSetValueForName = function goToAndSetValueForName(value) {
        if ( ! general.goTo()) {
            UIALogger.logError(this._objectName + ".goToAndSetValueForName(): failed to get to Settings>General");
            return(false);
        }
        return(this.nameSetValue(value));
    }

    general.fromAndSetValueForName = function fromAndSetValueForName(value) {
        return(this.nameSetValue(value));
    }

    general.nameGetValue = function nameGetValue() {
        var nameElement = this.appMenu().elementForName(this.kNameString, 0, 0, 4);
        if ( ! nameElement) {
            UIALogger.logError(this._objectName + ".nameGetValue(): cannot find menu item " + this.kNameString);
            return(false);
        }
        return(nameElement.value());
    }

    general.goToAndGetValueForName = function goToAndGetValueForName() {
        if ( ! general.goTo()) {
            UIALogger.logError(this._objectName + ".goToAndSetValueForName(): failed to get to Settings>General");
            return(false);
        }
        return(this.nameGetValue());
    }

    general.fromAndGetValueForName = function fromAndGetValueForName() {
        return(this.nameGetValue());
    }

    // methods for Network

    // Notice this returns the SSID when connected to WiFi, null for everything else
    general.getValueForNetwork = function getValueForNetwork(menu) {
        return(this.getMenuItemValue(menu, "Network"));
    }

    general.goToAndGetValueForNetwork = function goToAndGetValueForNetwork() {
        return(this.getValueForNetwork(this.goTo()));
    }

    general.fromAndGetValueForNetwork = function fromAndGetValueForNetwork() {
        return(this.getValueForNetwork(this.fromMenu()));
    }

    general.fromNetworkMenu = function fromNetworkMenu() {
        var menu = new ATVAPage("Network");
        if ( ! menu.waitForPage()) {
            UIALogger.logError(this._objectName + ".fromNetworkMenu(): failed to waiting for Network Menu");
            return(undefined);
        }
        return(menu);
    }

    general.goToNetworkMenu = function goToNetworkMenu() {
        if (this.goToAndSelect("Network")) {
            return(this.fromNetworkMenu());
        }
        return(undefined);
    }

    // methods for Time Zone

    general.fromTimeZoneMenu = function fromTimeZoneMenu() {
        var menu = new ATVAPage("Time Zone");
        if ( ! menu.waitForPage()) {
            UIALogger.logError(this._objectName + ".fromTimeZoneMenu(): failed to waiting for Bluetooth Menu");
            return(undefined);
        }
        return(menu);
    }

    general.goToTimeZoneMenu = function goToTimeZoneMenu() {
        if (this.goToAndSelect("Time Zone")) {
            return(this.fromTimeZoneMenu());
        }
        return(undefined);
    }

    general.isTimeZoneSetAutomatically = function isTimeZoneSetAutomatically(menu) {
        if ( ! menu) {
            UIALogger.logError(this._objectName + ".isTimeZoneSetAutomatically(): no menu given, cannot continue");
            return(false);
        }
        var focus = menu.moveToItemWithName("Set Automatically");
        if (focus && (focus.value() == "On")) {
            return(true);
        }
        else {
            return(false);
        }
    }

    general.setTimeZoneSetAutomatically = function setTimeZoneSetAutomatically(menu, setOn) {
        if ( ! menu) {
            UIALogger.logError(this._objectName + ".setTimeZoneSetAutomatically(): no menu given, cannot continue");
            return(undefined);
        }
        var focus = menu.moveToItemWithName("Set Automatically");
        while (focus) {
            if (setOn && (focus.value() == "On")) {
                return(focus);
            }
            else if (( ! setOn) && (focus.value() == "Off")) {
                return(focus);
            }
            menu.selectIntoPage();
            focus = menu.itemWithFocus();
        }
    }

    general.setTimeZone = function setTimeZone(menu, shortCityString, cityString) {
        if ( ! menu) {
            UIALogger.logError(this._objectName + ".setTimeZone(): no menu given, cannot continue");
            return(false);
        }
        if (general.isTimeZoneSetAutomatically(menu)) {
            UIALogger.logError(this._objectName + ".setTimeZone(): set automatically set to on, cannot set city");
            return(false);
        }
        var focus = menu.moveToItemWithName("Time Zone");
        if (focus && (focus.value() == shortCityString)) {
            return(true);
        }
        menu.selectIntoPage()
        var timeZoneMenu = new ATVAPageSearch("Time Zone");
        if ( ! timeZoneMenu.waitForPage()) {
            UIALogger.logError(this._objectName + ".setTimeZone(): failed waiting for Time Zone menu");
            return (false);
        }
        if ( ! timeZoneMenu.enterString(shortCityString)) {
            UIALogger.logError(this._objectName + ".setTimeZone(): failed entering string Search for Page");
            return (false);
        }
        if ( ! timeZoneMenu.moveToSearch(cityString)) {
            UIALogger.logError(this._objectName + ".setTimeZone(): search item was not returned");
            return (false);
        }
        timeZoneMenu.selectIntoPage()

        // Back to time zone menu
        if ( ! menu.waitForPage()) {
            UIALogger.logError(this._objectName + ".setTimeZone(): failed to waiting for Time Zone Menu");
            return(false);
        }
        focus = menu.moveToItemWithName("Time Zone");
        if (focus && (focus.value() == shortCityString)) {
        }
        else {
            UIALogger.logError(this._objectName + ".setTimeZone(): value appear to not get set");
            return(false);
        }
        return(true);
    }

    // methods for Sleep After

    // methods for Send Data to Apple

    general.sendDataMenuDisplayed = function sendDataMenuDisplayed() {
        if (appletv.mainWindow().buttons()["OK"].isValid() && appletv.mainWindow().buttons()["No Thanks"].isValid()) {
            return(true);
        }
        return(false);
    }

    general.sendDataSetValue = function sendDataSetValue(value) {
        var itemToSelect;
        var menuItemValue;
        if (value) {
            itemToSelect = "OK";
            menuItemValue = this.kSendDatatoAppleYesString;
        }
        else {
            itemToSelect = "No Thanks";
            menuItemValue = this.kSendDatatoAppleNoString;
        }

        var sendDataElement = this.appMenu().elementForName(this.kSendDatatoAppleString);
        if ( ! sendDataElement) {
            UIALogger.logError(this._objectName + ".sendDataSetValue(): cannot find menu item " + this.kSendDatatoAppleString);
            return(false);
        }

        if (menuItemValue == sendDataElement.value()) {
            // nothing to do.
            return(true);
        }

        if ( ! this.appMenu().moveToItemWithNameAndSelect(this.kSendDatatoAppleString) ) {
            UIALogger.logError(this._objectName + ".sendDataSetValue(): failed to get to select for " + this.kSendDatatoAppleString);
            return(false);
        }

        var sendDataMenu = new ATVAPage(this.kSendDatatoAppleString);
        sendDataMenu.isPageDisplayed = this.sendDataMenuDisplayed;
        if ( ! sendDataMenu.waitForPage()) {
            UIALogger.logError(this._objectName + ".sendDataSetValue(): failed to waiting for menu " + this.kSendDatatoAppleString);
            return(false);
        }

        if ( ! sendDataMenu.moveToItemWithNameAndSelect(itemToSelect)) {
            UIALogger.logError(this._objectName + ".sendDataSetValue(): failed to select item " + itemToSelect);
            return(false);
        }

        this.appMenu().resetList();
        if ( ! this.fromMenu()) {
            UIALogger.logError(this._objectName + ".sendDataSetValue(): failed to return to General menu");
            return(false);
        }

        sendDataElement = this.appMenu().elementForName(this.kSendDatatoAppleString);
        if ( ! sendDataElement) {
            UIALogger.logError(this._objectName + ".sendDataSetValue(): cannot find menu item " + this.kSendDatatoAppleString);
            return(false);
        }

        if (menuItemValue == sendDataElement.value()) {
            // nothing to do.
            return(true);
        }
        // failed to set send data
        UIALogger.logError(this._objectName + ".sendDataSetValue(): failed to set send data to " + menuItemValue);
        return(false);
    }

    general.goToAndSetSendData = function goToAndSetSendData(value) {
        if ( ! general.goTo()) {
            UIALogger.logError(this._objectName + ".goToAndSetSendData(): failed to get to Settings>General");
            return(false);
        }
        return(this.sendDataSetValue(value));
    }

    general.fromAndSetSendData = function fromAndSetSendData(value) {
        return(this.sendDataSetValue(value));
    }

    general.sendDataGetValue = function sendDataGetValue() {
        var nameElement = this.appMenu().elementForName(this.kSendDatatoAppleString);
        if ( ! nameElement) {
            UIALogger.logError(this._objectName + ".sendDataGetValue(): cannot find menu item " + this.kSendDatatoAppleString);
            return(false);
        }

        if (nameElement.value() == this.kSendDatatoAppleYesString) {
            return(true);
        }
        else if (nameElement.value() == this.kSendDatatoAppleNoString) {
            return(false);
        }
        else {
            UIALogger.logError(this._objectName + ".sendDataGetValue(): unknown menu item value " + nameElement.value());
            return(false);
        }
    }

    general.goToAndGetSendData = function goToAndGetSendData() {
        if ( ! general.goTo()) {
            UIALogger.logError(this._objectName + ".goToAndGetSendData(): failed to get to Settings>General");
            return(false);
        }
        return(this.sendDataGetValue());
    }

    general.fromAndGetSendData = function fromAndGetSendData() {
        return(this.sendDataGetValue());
    }

    // methods for Language

    general.languagesMenuItems = [
        "English",
        "Français",
        "Deutsch",
        "日本語",
        "Nederlands",
        "Italiano",
        "Español",
        "Português (Portugal)",
        "Dansk",
        "Suomi",
        "Norsk",
        "Svenska",
        "한국어",
        "简体中文",
        "繁體中文",
        "Русский",
        "Polski",
        "Português (Brasil)",
        "Bahasa Indonesia",
        "British English",
        "Türkçe",
        "Magyar",
        "English",
        "Ελληνικά",
        "Català",
        "English",
        "ไทย",
        "Bahasa Melayu",
        "Čeština",
        "Slovenčina",
        "Tiếng Việt",
        "Română",
        "Українська",
        "English",
        "Hrvatski",
    ];

    general._languageMenu = undefined;
    general.languageMenu = function languageMenu() {
        if ( ! this._languageMenu ) {
            this._languageMenu = new ATVAPageList(this.kLanguageString);
            this._languageMenu.setRequiredButtons(["English"]);
            this._languageMenu.setListCenter();
        }
        return( this._languageMenu );
    }

    general.fromLanguageMenu = function fromLanguageMenu(pageRequiresResetOnPush) {
        if (typeof pageRequiresResetOnPush == 'undefined') {
            pageRequiresResetOnPush = false;
        }
        if (pageRequiresResetOnPush) {
            this.languageMenu().resetPage();
        }
        if ( ! this.languageMenu().waitForPage()) {
            UIALogger.logError(this._objectName + ".fromLanguageMenu(): failed to waiting for " + this.kLanguageString);
            return(undefined);
        }
        return(this.languageMenu());
    }

    general.goToLanguageMenu = function goToLanguageMenu() {
        if (this.goToAndSelect(this.kLanguageString)) {
            return(this.fromLanguageMenu(true));
        }
        UIALogger.logError(this._objectName + ".goToLanguageMenu(): failed to get to " + this.kLanguageString);
        return(undefined);
    }

    // methods for Region Format

    general.regionFormatMenuItems = [
        "Afghanistan",
        "Åland Islands",
        "Albania",
        "Algeria",
        "American Samoa",
        "Andorra",
        "Angola",
        "Anguilla",
        "Antarctica",
        "Antigua and Barbuda",
        "Argentina",
        "Armenia",
        "Aruba",
        "Australia",
        "Austria",
        "Azerbaijan",
        "Bahamas",
        "Bahrain",
        "Bangladesh",
        "Barbados",
        "Belarus",
        "Belgium",
        "Belize",
        "Benin",
        "Bermuda",
        "Bhutan",
        "Bolivia",
        "Bosnia and Herzegovina",
        "Botswana",
        "Bouvet Island",
        "Brazil",
        "British Indian Ocean Territory",
        "British Virgin Islands",
        "Brunei",
        "Bulgaria",
        "Burkina Faso",
        "Burundi",
        "Cambodia",
        "Cameroon",
        "Canada",
        "Cape Verde",
        "Caribbean Netherlands",
        "Cayman Islands",
        "Central African Republic",
        "Chad",
        "Chile",
        "China",
        "Christmas Island",
        "Cocos [Keeling] Islands",
        "Colombia",
        "Comoros",
        "Congo - Brazzaville",
        "Congo - Kinshasa",
        "Cook Islands",
        "Costa Rica",
        "Côte d’Ivoire",
        "Croatia",
        "Cuba",
        "Curaçao",
        "Cyprus",
        "Czech Republic",
        "Denmark",
        "Djibouti",
        "Dominica",
        "Dominican Republic",
        "Ecuador",
        "Egypt",
        "El Salvador",
        "Equatorial Guinea",
        "Eritrea",
        "Estonia",
        "Ethiopia",
        "Falkland Islands",
        "Faroe Islands",
        "Fiji",
        "Finland",
        "France",
        "French Guiana",
        "French Polynesia",
        "French Southern Territories",
        "Gabon",
        "Gambia",
        "Georgia",
        "Germany",
        "Ghana",
        "Gibraltar",
        "Greece",
        "Greenland",
        "Grenada",
        "Guadeloupe",
        "Guam",
        "Guatemala",
        "Guernsey",
        "Guinea",
        "Guinea-Bissau",
        "Guyana",
        "Haiti",
        "Heard Island and McDonald Islands",
        "Honduras",
        "Hong Kong SAR China",
        "Hungary",
        "Iceland",
        "India",
        "Indonesia",
        "Iran",
        "Iraq",
        "Ireland",
        "Isle of Man",
        "Israel",
        "Italy",
        "Jamaica",
        "Japan",
        "Jersey",
        "Jordan",
        "Kazakhstan",
        "Kenya",
        "Kiribati",
        "Kuwait",
        "Kyrgyzstan",
        "Laos",
        "Latvia",
        "Lebanon",
        "Lesotho",
        "Liberia",
        "Libya",
        "Liechtenstein",
        "Lithuania",
        "Luxembourg",
        "Macau SAR China",
        "Macedonia",
        "Madagascar",
        "Malawi",
        "Malaysia",
        "Maldives",
        "Mali",
        "Malta",
        "Marshall Islands",
        "Martinique",
        "Mauritania",
        "Mauritius",
        "Mayotte",
        "Mexico",
        "Micronesia",
        "Moldova",
        "Monaco",
        "Mongolia",
        "Montenegro",
        "Montserrat",
        "Morocco",
        "Mozambique",
        "Myanmar [Burma]",
        "Namibia",
        "Nauru",
        "Nepal",
        "Netherlands",
        "New Caledonia",
        "New Zealand",
        "Nicaragua",
        "Niger",
        "Nigeria",
        "Niue",
        "Norfolk Island",
        "North Korea",
        "Northern Mariana Islands",
        "Norway",
        "Oman",
        "Pakistan",
        "Palau",
        "Palestinian Territories",
        "Panama",
        "Papua New Guinea",
        "Paraguay",
        "Peru",
        "Philippines",
        "Pitcairn Islands",
        "Poland",
        "Portugal",
        "Puerto Rico",
        "Qatar",
        "Réunion",
        "Romania",
        "Russia",
        "Rwanda",
        "Saint Barthélemy",
        "Saint Helena",
        "Saint Kitts and Nevis",
        "Saint Lucia",
        "Saint Martin",
        "Saint Pierre and Miquelon",
        "Saint Vincent and the Grenadines",
        "Samoa",
        "San Marino",
        "São Tomé and Príncipe",
        "Saudi Arabia",
        "Senegal",
        "Serbia",
        "Seychelles",
        "Sierra Leone",
        "Singapore",
        "Sint Maarten",
        "Slovakia",
        "Slovenia",
        "Solomon Islands",
        "Somalia",
        "South Africa",
        "South Georgia and the South Sandwich Islands",
        "South Korea",
        "South Sudan",
        "Spain",
        "Sri Lanka",
        "Sudan",
        "Suriname",
        "Svalbard and Jan Mayen",
        "Swaziland",
        "Sweden",
        "Switzerland",
        "Syria",
        "Taiwan",
        "Tajikistan",
        "Tanzania",
        "Thailand",
        "Timor-Leste",
        "Togo",
        "Tokelau",
        "Tonga",
        "Trinidad and Tobago",
        "Tunisia",
        "Turkey",
        "Turkmenistan",
        "Turks and Caicos Islands",
        "Tuvalu",
        "U.S. Outlying Islands",
        "U.S. Virgin Islands",
        "Uganda",
        "Ukraine",
        "United Arab Emirates",
        "United Kingdom",
        "United States",
        "Uruguay",
        "Uzbekistan",
        "Vanuatu",
        "Vatican City",
        "Venezuela",
        "Vietnam",
        "Wallis and Futuna",
        "Western Sahara",
        "Yemen",
        "Zambia",
        "Zimbabwe",
    ];

    general._regionFormatMenu = undefined;
    general.regionFormatMenu = function regionFormatMenu() {
        if ( ! this._regionFormatMenu ) {
            this._regionFormatMenu = new ATVAPageList(this.kRegionFormatString);
            this._regionFormatMenu.setListCenter();
        }
        return( this._regionFormatMenu );
    }

    general.fromRegionFormatMenu = function fromRegionFormatMenu(pageRequiresResetOnPush) {
        if (typeof pageRequiresResetOnPush == 'undefined') {
            pageRequiresResetOnPush = false;
        }
        if (pageRequiresResetOnPush) {
            this.regionFormatMenu().resetPage();
        }
        if ( ! this.regionFormatMenu().waitForPage()) {
            UIALogger.logError(this._objectName + ".fromRegionFormatMenu(): failed to waiting for " + this.kRegionFormatString);
            return(undefined);
        }
        return(this.regionFormatMenu());
    }

    general.goToRegionFormatMenu = function goToRegionFormatMenu() {
        if (this.goToAndSelect(this.kRegionFormatString)) {
            return(this.fromRegionFormatMenu(true));
        }
        UIALogger.logError(this._objectName + ".goToRegionFormatMenu(): failed to get to " + this.kRegionFormatString);
        return(undefined);
    }

    // methods for Troubleshooting

    // methods for Legal

    // methods for Reset

    // methods for Restart

    general.restart = function restart() {
        return(this.goToAndSelect("Restart"));
    }

    // methods for Feature Enabler
}
