
#import "Bluetooth.js"

/**
 *       Function: bluetoothTest_verifyMenuContents
 *           Verifies that expect menu items.
 *   
 *  \return 1 success, otherwise 0
 **/

function bluetoothTest_verifyMenuContents() {
    if ( ! bluetooth.goTo()) {
        this.testError = "Fail to get to Settings>General>Bluetooth";
        return this.testResult = 0;
    }

    if ( ! bluetooth.appMenu().verifyMenuContents(bluetooth.menuItems) ) {
        this.testError = "Menu contents verification failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: bluetoothTest_verifyMenuNavigation
 *           Verifies the basic navigation of the page.
 *   
 *  \return 1 success, otherwise 0
 **/

function bluetoothTest_verifyMenuNavigation() {
    if ( ! bluetooth.goTo()) {
        this.testError = "Fail to get to Settings>General>Bluetooth";
        return this.testResult = 0;
    }

    if ( ! bluetooth.appMenu().verifyMenuNavigation(bluetooth.menuItems, bluetooth.menuItemsNavigation) ) {
        this.testError = "Menu navigation verification failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: bluetoothTest_verifyDefaultValues
 *           Verifies the default values for Settings>Audio & Video. Assumes that the defaults
 *           are currently set.
 *   
 *  \return 1 success, otherwise 0
 **/

function bluetoothTest_verifyDefaultValues() {
    if ( ! bluetooth.goTo()) {
        this.testError = "Fail to get to Settings>General>Bluetooth";
        return this.testResult = 0;
    }

    if ( bluetooth.isBluetoothOff() ) {
        this.testError = "Bluetooth is off, should be on";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: bluetoothTest_verifyToggleValues
 *           Verify that toggle values can be changed to the expected values.
 *   
 *  \return 1 success, otherwise 0
 **/

function bluetoothTest_verifyToggleValues() {
    if ( ! bluetooth.goTo()) {
        this.testError = "Fail to get to Settings>General>Bluetooth";
        return this.testResult = 0;
    }

    var toggleFailed = false;

    // true off
    if ( ! bluetooth.toggleBluetooth(false) ) {
        UIALogger.logError("Failed to turn Bluetooth off");
        toggleFailed = true;
    }
    // true on
    if ( ! bluetooth.toggleBluetooth(true) ) {
        UIALogger.logError("Failed to turn Bluetooth on");
        toggleFailed = true;
    }

    if ( toggleFailed ) {
        this.testError = "Bluetooth toggling failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: bluetoothTest_turnOnBluetooth
 *           Sets the value for a select.
 *   
 *  \return 1 success, otherwise 0
 **/

function bluetoothTest_turnOnBluetooth() {
    if (this.argv.length < 1) {
        this.testError = "Arguments not specified";
        return this.testResult = 0;
    }
    var turnOn = false;
    if (this.argv[0].toUpperCase() == "TRUE") {
        turnOn = true;
    }

    if ( ! bluetooth.toggleBluetooth(turnOn) ) {
        if ( turnOn ) {
            this.testError = "Failed to turn on Bluetooth";
        }
        else {
            this.testError = "Failed to turn off Bluetooth";
        }
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}
