
#import "General.js"

// --------------------------------------------------------------------------------
//      Object: bluetooth
//              bluetooth is an ATVAApp object for interacting with the
//              Settings/General/Bluetooth appliance on Apple TV.
// --------------------------------------------------------------------------------

if (typeof bluetooth == 'undefined') {
    bluetooth = new ATVAApp("Bluetooth");
}

if (typeof bluetooth != 'undefined') {
    bluetooth._objectName = "bluetooth";

    bluetooth.kBluetooth = "Bluetooth";

    bluetooth.kBluetoothOn = "Searching…";
    bluetooth.kBluetoothOff = "Off";
    
    bluetooth.menuItems = [
        bluetooth.kBluetooth
    ];
    bluetooth.menuItemsWithValues = [
        bluetooth.kBluetooth
    ];

    bluetooth.toggleMenuItemsAndValues = undefined;
    bluetooth.setToggleMenuItemsAndValues = function setToggleMenuItemsAndValues() {
        this.toggleMenuItemsAndValues = {};
        this.toggleMenuItemsAndValues[this.kBluetooth] = [this.kBluetoothOn, this.kBluetoothOff];
    }
    bluetooth.setToggleMenuItemsAndValues();

    bluetooth.menuItemsDefaultValues = undefined;
    bluetooth.setMenuItemsDefaultValues = function setMenuItemsDefaultValues() {
        this.menuItemsDefaultValues = {};
        this.menuItemsDefaultValues[this.kBluetooth] = this.kBluetoothOn;
    }
    bluetooth.setMenuItemsDefaultValues();

    bluetooth.menuItemsNavigation = undefined;
    bluetooth.setMenuItemsNavigation = function setMenuItemsNavigation() {
        this.menuItemsNavigation = {};
        this.menuItemsNavigation[this.kBluetooth] = [
            {"action":"up", "result":"noop"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
        ];
    }
    bluetooth.setMenuItemsNavigation();

    bluetooth.appMenu = function appMenu() {
        if ( ! this._appMenu ) {
            this._appMenu = new ATVAPageList(this._title);
            this._appMenu.setListScrolls(false);
        }
        return( this._appMenu );
    }

    bluetooth.reload = function reload() {
        this.appMenu().resetList();
    }

    bluetooth.goTo = function goTo() {
        // Indexes are not saved when we go back to the Main Menu
        this.reload();
        if (general.goToAndSelect(this._title)) {
            return(this.fromMenu());
        }
        UIALogger.logError(this._objectName + ".goTo(): failed to get to " + this._title);
        return(undefined);
    }

    bluetooth.isBluetoothOff = function isBluetoothOff() {
        // force a reload before looking
        this.reload();

        var bluetoothElement = this.appMenu().elementForName(this.kBluetooth, 0, 0, 0)
        if ( ! bluetoothElement ) {
            UIALogger.logError(this._objectName + ": failed to find " + this.kBluetooth);
            return(false);
        }

        if ( bluetoothElement.value() == bluetooth.kBluetoothOff ) {
            return(true);
        }
        else {
            return(false);
        }
    }

    bluetooth.toggleBluetooth = function toggleBluetooth(state) {
        if ( ! this.fromMenu() ) {
            UIALogger.logError(this._objectName + ".toggleBluetooth(): not on Bluetooth menu");
            return(false);
        }

        if ( state ) {
            // turn on
            if ( ! this.isBluetoothOff() ) {
                return(true);
            }
            if ( ! this.appMenu().moveToItemWithNameAndSelect(this.kBluetooth) ) {
                UIALogger.logError(this._objectName + ".toggleBluetooth(): failed to select " + this.kBluetooth);
                return(false);
            }

            // can take a few seconds to change state
            atvaTarget.delay(5);

            if ( this.isBluetoothOff() ) {
                return(false);
            }
            else {
                return(true);
            }
        }
        else {
            // turn off
            if ( this.isBluetoothOff() ) {
                return(true);
            }
            if ( ! this.appMenu().moveToItemWithNameAndSelect(this.kBluetooth) ) {
                UIALogger.logError(this._objectName + ".toggleBluetooth(): failed to select " + this.kBluetooth);
                return(false);
            }

            // can take a few seconds to change state
            atvaTarget.delay(5);

            if ( this.isBluetoothOff() ) {
                return(true);
            }
            else {
                return(false);
            }
        }
    }

    bluetooth.goToAndToggleBluetooth = function goToAndToggleBluetooth(state) {
        if ( ! this.goTo() ) {
            UIALogger.logError(this._objectName + ".goToAndToggleBluetooth(): cannot toggle Bluetooth setting");
            return(false);
        }

        return(this.toggleBluetooth(state));
    }

    bluetooth.fromAndToggleBluetooth = function fromAndToggleBluetooth(state) {
        return(this.toggleBluetooth(state));
    }
}
