
#import "Accessibility.js"

/**
 *       Function: accessibilityTest_verifyMenuContents
 *           Verifies that expect menu items.
 *   
 *  \return 1 success, otherwise 0
 **/

function accessibilityTest_verifyMenuContents() {
    if ( ! accessibility.goTo()) {
        this.testError = "Fail to get to Settings>General>Accessibility";
        return this.testResult = 0;
    }

    if ( ! accessibility.appMenu().verifyMenuContents(accessibility.menuItems) ) {
        this.testError = "Menu contents verification failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: accessibilityTest_verifyMenuNavigation
 *           Verifies the basic navigation of the page.
 *   
 *  \return 1 success, otherwise 0
 **/

function accessibilityTest_verifyMenuNavigation() {
    if ( ! accessibility.goTo()) {
        this.testError = "Fail to get to Settings>General>Accessibility";
        return this.testResult = 0;
    }

    if ( ! accessibility.appMenu().verifyMenuNavigation(accessibility.menuItems, accessibility.menuItemsNavigation) ) {
        this.testError = "Menu navigation verification failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: accessibilityTest_verifyDefaultValues
 *           Verifies the default values for Settings>Audio & Video. Assumes that the defaults
 *           are currently set.
 *   
 *  \return 1 success, otherwise 0
 **/

function accessibilityTest_verifyDefaultValues() {
    if ( ! accessibility.goTo()) {
        this.testError = "Fail to get to Settings>General>Accessibility";
        return this.testResult = 0;
    }

    if ( ! accessibility.appMenu().verifyDefaultValues(accessibility.menuItemsWithValues, accessibility.menuItemsDefaultValues) ) {
        this.testError = "Menu default value verification failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}
