
#import "General.js"

// --------------------------------------------------------------------------------
//      Object: accessibility
//              accessibility is an ATVAApp object for interacting with the
//              Accessibility appliance on Apple TV.
// --------------------------------------------------------------------------------

if (typeof accessibility == 'undefined') {
    accessibility = new ATVAApp("Accessibility");
}

if (typeof accessibility != 'undefined') {
    accessibility._objectName = "accessibility";

    accessibility.kVoiceOverString = "VoiceOver";
    accessibility.kSpeechRateString = "Speech Rate";
    accessibility.kUsePitchString = "Use Pitch";
    accessibility.kAccessibilityMenuString = "Accessibility Menu";
    accessibility.kClosedCaptionsSDHString = "Closed Captions + SDH";
    accessibility.kStyleString = "Style";

    accessibility.kVoiceOverOnString = "On";
    accessibility.kVoiceOverOffString = "Off";

    accessibility.kSpeechRateSlowString = "Slow";
    accessibility.kSpeechRateNormalString = "Normal";
    accessibility.kSpeechRateFastString = "Fast";
    accessibility.kSpeechRateVeryFastString = "Very Fast";

    accessibility.kUsePitchOnString = "On";
    accessibility.kUsePitchOffString = "Off";

    accessibility.kAccessibilityMenuOnString = "On";
    accessibility.kAccessibilityMenuOffString = "Off";

    accessibility.kClosedCaptionsSDHOnString = "On";
    accessibility.kClosedCaptionsSDHOffString = "Off";

    accessibility.kStyleDefaultString = "Default";
    
    accessibility.menuItems = [
        accessibility.kVoiceOverString,
        accessibility.kSpeechRateString,
        accessibility.kUsePitchString,
        accessibility.kAccessibilityMenuString,
        accessibility.kClosedCaptionsSDHString,
        accessibility.kStyleString
    ];
    accessibility.menuItemsWithValues = [
        accessibility.kVoiceOverString,
        accessibility.kSpeechRateString,
        accessibility.kUsePitchString,
        accessibility.kAccessibilityMenuString,
        accessibility.kClosedCaptionsSDHString,
        accessibility.kStyleString
    ];

    accessibility.toggleMenuItemsAndValues = undefined;
    accessibility.setToggleMenuItemsAndValues = function setToggleMenuItemsAndValues() {
        this.toggleMenuItemsAndValues = {};
        this.toggleMenuItemsAndValues[this.kVoiceOverString] = [this.kVoiceOverOnString, this.kVoiceOverOffString];
        this.toggleMenuItemsAndValues[this.kSpeechRateString] = [this.kSpeechRateSlowString, this.kSpeechRateNormalString, this.kSpeechRateFastString, this.kSpeechRateVeryFastString];
        this.toggleMenuItemsAndValues[this.kUsePitchString] = [this.kUsePitchOnString, this.kUsePitchOffString];
        this.toggleMenuItemsAndValues[this.kAccessibilityMenuString] = [this.kAccessibilityMenuOnString, this.kAccessibilityMenuOffString];
        this.toggleMenuItemsAndValues[this.kClosedCaptionsSDHString] = [this.kClosedCaptionsSDHOnString, this.kClosedCaptionsSDHOffString];
    }
    accessibility.setToggleMenuItemsAndValues();

    accessibility.menuItemsDefaultValues = undefined;
    accessibility.setMenuItemsDefaultValues = function setMenuItemsDefaultValues() {
        this.menuItemsDefaultValues = {};
        this.menuItemsDefaultValues[this.kVoiceOverString] = this.kVoiceOverOffString;
        this.menuItemsDefaultValues[this.kSpeechRateString] = this.kSpeechRateNormalString;
        this.menuItemsDefaultValues[this.kUsePitchString] = this.kUsePitchOffString;
        this.menuItemsDefaultValues[this.kAccessibilityMenuString] = this.kAccessibilityMenuOffString;
        this.menuItemsDefaultValues[this.kClosedCaptionsSDHString] = this.kClosedCaptionsSDHOffString;
        this.menuItemsDefaultValues[this.kStyleString] = this.kStyleDefaultString;
    }
    accessibility.setMenuItemsDefaultValues();

    accessibility.menuItemsNavigation = undefined;
    accessibility.setMenuItemsNavigation = function setMenuItemsNavigation() {
        this.menuItemsNavigation = {};
        this.menuItemsNavigation[this.kVoiceOverString] = [
            {"action":"up", "result":"noop"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"},
        ];
        this.menuItemsNavigation[this.kSpeechRateString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"},
        ];
        this.menuItemsNavigation[this.kUsePitchString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"},
        ];
        this.menuItemsNavigation[this.kAccessibilityMenuString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"},
        ];
        this.menuItemsNavigation[this.kClosedCaptionsSDHString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"},
        ];
        this.menuItemsNavigation[this.kStyleString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"noop"},
        ];
    }
    accessibility.setMenuItemsNavigation();

    accessibility.appMenu = function appMenu() {
        if ( ! this._appMenu ) {
            this._appMenu = new ATVAPageList(this._title);
            this._appMenu.setListScrolls(false);
        }
        return( this._appMenu );
    }

    accessibility.reload = function reload() {
        this.appMenu().resetList();
    }

    accessibility.goTo = function goTo() {
        // Indexes are not saved when we go back to the Main Menu
        this.reload();
        if (general.goToAndSelect(this._title)) {
            return(this.fromMenu());
        }
        UIALogger.logError(this._objectName + ".goTo(): failed to get to " + this._title);
        return(undefined);
    }
}
