
#import "About.js"

/**
 *       Function: aboutTest_verifyAboutContents
 *           Verifies that expect menu items.
 *   
 *  \return 1 success, otherwise 0
 **/

function aboutTest_verifyAboutContents() {
    if (this.argv.length < 1) {
        this.testError = "Arguments not specifed";
        return this.testResult = 0;
    }
    var isWiFi = false;
    if (this.argv[0].toUpperCase() == "TRUE") {
        isWiFi = true;
    }

    var menu = about.goTo(isWiFi);

    if ( ! menu) {
        this.testError = "Fail to get to Settings>General>About";
        return this.testResult = 0;
    }
    else {
        if ( ! menu.verifyStates()) {
            menu.printInfo();
            this.testError = "Menu contents verification failed";
            return this.testResult = 0;
        }
        menu.printInfo();
        return this.testResult = 1;
    }
}
