
#import "AudioVideo.js"

/**
 *       Function: audiovideoTest_verifyMenuContents
 *           Verifies that expect menu items.
 *   
 *  \return 1 success, otherwise 0
 **/

function audiovideoTest_verifyMenuContents() {
    if ( ! audiovideo.goTo()) {
        this.testError = "Fail to get to Settings>Audio & Video";
        return this.testResult = 0;
    }

    if ( ! audiovideo.appMenu().verifyMenuContents(audiovideo.menuItems) ) {
        this.testError = "Menu contents verification failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: audiovideoTest_verifyMenuNavigation
 *           Verifies the basic navigation of the page.
 *   
 *  \return 1 success, otherwise 0
 **/

function audiovideoTest_verifyMenuNavigation() {
    if ( ! audiovideo.goTo()) {
        this.testError = "Fail to get to Settings>Audio & Video";
        return this.testResult = 0;
    }

    if ( ! audiovideo.appMenu().verifyMenuNavigation(audiovideo.menuItems, audiovideo.menuItemsNavigation) ) {
        this.testError = "Menu navigation verification failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: audiovideoTest_verifyDefaultValues
 *           Verifies the default values for Settings>Audio & Video. Assumes that the defaults
 *           are currently set.
 *   
 *  \return 1 success, otherwise 0
 **/

function audiovideoTest_verifyDefaultValues() {
    if ( ! audiovideo.goTo()) {
        this.testError = "Fail to get to Settings>Audio & Video";
        return this.testResult = 0;
    }

    if ( ! audiovideo.appMenu().verifyDefaultValues(audiovideo.menuItemsWithValues, audiovideo.menuItemsDefaultValues) ) {
        this.testError = "Menu default value verification failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: audiovideoTest_verifyToggleValues
 *           Verify that toggle values can be changed to the expected values.
 *   
 *  \return 1 success, otherwise 0
 **/

function audiovideoTest_verifyToggleValues() {
    if ( ! audiovideo.goTo()) {
        this.testError = "Fail to get to Settings>Audio & Video";
        return this.testResult = 0;
    }

    if ( ! audiovideo.appMenu().verifyToggleValues(audiovideo.toggleMenuItemsAndValues, []) ) {
        this.testError = "Menu toggle value verification failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: audiovideoTest_testSelectValues
 *           Verify that select values can be changed to the expected values.
 *   
 *  \return 1 success, otherwise 0
 **/

function audiovideoTest_verifySelectValues() {
    if ( ! audiovideo.goTo()) {
        this.testError = "Fail to get to Settings>Audio & Video";
        return this.testResult = 0;
    }

    if ( ! audiovideo.appMenu().verifySelectValues(audiovideo.selectListMenuItemsAndValues, ['HDMI Output', 'TV Resuolution']) ) {
        this.testError = "Menu select value verification failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: audiovideoTest_setValuesToDefaults
 *           Tries to set all values back to there defaults.
 *   
 *  \return 1 success, otherwise 0
 **/

function audiovideoTest_setValuesToDefaults() {
    if ( ! audiovideo.goTo()) {
        this.testError = "Fail to get to Settings>Audio & Video";
        return this.testResult = 0;
    }

    var theErrorCount = 0;

    // Toggles
    var keys = Object.keys(audiovideo.toggleMenuItemsAndValues);
    var ignoreToggles = [];
    for (var i = 0; i < keys.length; ++i) {
        if (ignoreToggles.indexOf(keys[i]) > -1) {
            // skipping
            continue;
        }
        if ( ! audiovideo.appMenu().toggleItem(keys[i], audiovideo.menuItemsDefaultValues[keys[i]], audiovideo.toggleMenuItemsAndValues[keys[i]])) {
            ++theErrorCount;
            UIALogger.logError("Failed to set value " + keys[i] + " back to " + audiovideo.menuItemsDefaultValues[keys[i]]);
        }
    }

    // Selects
    keys = Object.keys(audiovideo.selectListMenuItemsAndValues);
    var ignoreSelects = ['HDMI Output', 'TV Resuolution'];
    for (var i = 0; i < keys.length; ++i) {
        if (ignoreSelects.indexOf(keys[i]) > -1) {
            // skipping
            continue;
        }
        if ( ! audiovideo.appMenu().selectItem(keys[i], audiovideo.menuItemsDefaultValues[keys[i]])) {
            ++theErrorCount;
            UIALogger.logError("Failed to set value " + keys[i] + " back to " + audiovideo.menuItemsDefaultValues[keys[i]]);
        }
    }

    if (theErrorCount > 0) {
        this.testError = "Setting values back to defaults failed";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: audiovideoTest_setToggleValueTo
 *           Sets the value for a toggle.
 *   
 *  \return 1 success, otherwise 0
 **/

function audiovideoTest_setToggleValueTo() {
    if (this.argv.length < 2) {
        this.testError = "Arguments not specified";
        return this.testResult = 0;
    }
    var item = this.argv[0];
    var value = this.argv[1];

    if ( ! audiovideo.goToAndSetValueForToggle(item, value) ) {
        this.testError = "Failed to set value";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

/**
 *       Function: audiovideoTest_setSelectValueTo
 *           Sets the value for a select.
 *   
 *  \return 1 success, otherwise 0
 **/

function audiovideoTest_setSelectValueTo() {
    if (this.argv.length < 2) {
        this.testError = "Arguments not specified";
        return this.testResult = 0;
    }
    var item = this.argv[0];
    var value = this.argv[1];

    if ( ! audiovideo.goToAndSetValueForSelect(item, value) ) {
        this.testError = "Failed to set value";
        return this.testResult = 0;
    }
    else {
        return this.testResult = 1;
    }
}

