
#import "../Settings.js"

// --------------------------------------------------------------------------------
//      Object: audiovideo
//              audiovideo is an ATVAApp object for interacting with the
//              Settings>Audio & Video menu on Apple TV.
// --------------------------------------------------------------------------------

if (typeof audiovideo == 'undefined') {
    audiovideo = new ATVAApp("Audio & Video");
}

if (typeof audiovideo != 'undefined') {
    audiovideo._objectName = "audiovideo";

    audiovideo.kRepeatMusicString = "Repeat Music";
    audiovideo.kSoundCheckString = "Sound Check";
    audiovideo.kSoundEffectsString = "Sound Effects";
    audiovideo.kShowPlaylistsString = "Show Playlists";
    audiovideo.kDolbyDigitalString = "Dolby Digital";
    audiovideo.kAudioOutputString = "Audio Output";
    audiovideo.kAudioLanguageString = "Audio Language";
    audiovideo.kSubtitleLanguageString = "Subtitle Language";
    audiovideo.kAdjustForAirPlayOverscanString = "Adjust For AirPlay Overscan";
    audiovideo.kHDMIOutputString = "HDMI Output";
    audiovideo.kTVResolutionString = "TV Resolution";
    
    audiovideo.menuItems = [
        'Repeat Music',
        'Sound Check',
        'Sound Effects',
        'Show Playlists',
        'Dolby Digital',
        'Audio Output',
        'Audio Language',
        'Subtitle Language',
        'Adjust For AirPlay Overscan',
        'HDMI Output',
        'TV Resolution'
    ];
    audiovideo.menuItemsWithValues = [
        'Repeat Music',
        'Sound Check',
        'Sound Effects',
        'Show Playlists',
        'Dolby Digital',
        'Audio Output',
        'Audio Language',
        'Subtitle Language',
        'Adjust For AirPlay Overscan',
        'HDMI Output',
        'TV Resolution'
    ];

    audiovideo.toggleMenuItemsAndValues = undefined;
    audiovideo.setToggleMenuItemsAndValues = function setToggleMenuItemsAndValues() {
        this.toggleMenuItemsAndValues = {};
        this.toggleMenuItemsAndValues[this.kRepeatMusicString] = ['Off', 'On'];
        this.toggleMenuItemsAndValues[this.kSoundCheckString] = ['Off', 'On'];
        this.toggleMenuItemsAndValues[this.kSoundEffectsString] = ['Off', 'On'];
        this.toggleMenuItemsAndValues[this.kShowPlaylistsString] = ['Music Only', 'All'];
        this.toggleMenuItemsAndValues[this.kDolbyDigitalString] = ['Auto', 'On', 'Off'];
        this.toggleMenuItemsAndValues[this.kAudioOutputString] = ['Auto', '16 bit'];
        this.toggleMenuItemsAndValues[this.kAdjustForAirPlayOverscanString] = ['Off', 'On'];
    }
    audiovideo.setToggleMenuItemsAndValues();

    audiovideo.menuItemsDefaultValues = undefined;
    audiovideo.setMenuItemsDefaultValues = function setMenuItemsDefaultValues() {
        this.menuItemsDefaultValues = {};
        this.menuItemsDefaultValues[this.kRepeatMusicString] = 'Off';
        this.menuItemsDefaultValues[this.kSoundCheckString] = 'Off';
        this.menuItemsDefaultValues[this.kSoundEffectsString] = 'On';
        this.menuItemsDefaultValues[this.kShowPlaylistsString] = 'Music Only';
        this.menuItemsDefaultValues[this.kDolbyDigitalString] = 'Auto';
        this.menuItemsDefaultValues[this.kAudioOutputString] = 'Auto';
        this.menuItemsDefaultValues[this.kAudioLanguageString] = 'Default';
        this.menuItemsDefaultValues[this.kSubtitleLanguageString] = 'Auto';
        this.menuItemsDefaultValues[this.kAdjustForAirPlayOverscanString] = 'On';
        this.menuItemsDefaultValues[this.kHDMIOutputString] = 'Auto';
        this.menuItemsDefaultValues[this.kTVResolutionString] = 'Auto';
    }
    audiovideo.setMenuItemsDefaultValues();

    audiovideo.selectListMenuItemsAndValues = undefined;
    audiovideo.setSelectListMenuItemsAndValues = function setSelectListMenuItemsAndValues() {
        this.selectListMenuItemsAndValues = {};
        this.selectListMenuItemsAndValues[this.kAudioLanguageString] = ['Default', 'English', 'French', 'German', 'Japanese', 'Dutch', 'Italian', 'Spanish', 'Danish', 'Finnish', 'Norwegian Bokmål', 'Swedish', 'Korean', 'Chinese', 'Russian', 'Polish', 'Portuguese', 'Indonesian', 'Turkish', 'Hungarian', 'Greek', 'Catalan', 'Hindi', 'Thai', 'Malay', 'Czech', 'Slovak', 'Vietnamese', 'Romanian', 'Ukrainian', 'Croatian'];
        this.selectListMenuItemsAndValues[this.kSubtitleLanguageString] = ['Off', 'Auto', 'English', 'French', 'German', 'Japanese', 'Dutch', 'Italian', 'Spanish', 'Danish', 'Finnish', 'Norwegian Bokmål', 'Swedish', 'Korean', 'Chinese', 'Russian', 'Polish', 'Portuguese', 'Indonesian', 'Turkish', 'Hungarian', 'Greek', 'Catalan', 'Hindi', 'Thai', 'Malay', 'Czech', 'Slovak', 'Vietnamese', 'Romanian', 'Ukrainian', 'Croatian'];
        this.selectListMenuItemsAndValues[this.kHDMIOutputString] = ['Auto', 'YCbCr', 'RGB High', 'RGB Low'];
        this.selectListMenuItemsAndValues[this.kTVResolutionString] = ['Auto'];
    }
    audiovideo.setSelectListMenuItemsAndValues();

    audiovideo.menuItemsNavigation = undefined;
    audiovideo.setMenuItemsNavigation = function setMenuItemsNavigation() {
        this.menuItemsNavigation = {};
        this.menuItemsNavigation[this.kRepeatMusicString] = [
            {"action":"up", "result":"noop"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"},
        ];
        this.menuItemsNavigation[this.kSoundCheckString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"},
        ];
        this.menuItemsNavigation[this.kSoundEffectsString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"},
        ];
        this.menuItemsNavigation[this.kShowPlaylistsString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"},
        ];
        this.menuItemsNavigation[this.kDolbyDigitalString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"},
        ];
        this.menuItemsNavigation[this.kAudioOutputString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"},
        ];
        this.menuItemsNavigation[this.kAudioLanguageString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"},
        ];
        this.menuItemsNavigation[this.kSubtitleLanguageString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"},
        ];
        this.menuItemsNavigation[this.kAdjustForAirPlayOverscanString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"},
        ];
        this.menuItemsNavigation[this.kHDMIOutputString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"next"},
        ];
        this.menuItemsNavigation[this.kTVResolutionString] = [
            {"action":"up", "result":"previous"},
            {"action":"left", "result":"noop"},
            {"action":"right", "result":"noop"},
            {"action":"playpause", "result":"noop"},
            {"action":"down", "result":"noop"},
        ];
    }
    audiovideo.setMenuItemsNavigation();

    // overriding appMenu(), and goTo() methods from base ATVAApp()
    audiovideo.appMenu = function appMenu() {
        if ( ! this._appMenu ) {
            this._appMenu = new ATVAPageList(this._title);
            this._appMenu.setListScrolls(false);
        }
        return( this._appMenu );
    }

    audiovideo.goTo = function goTo() {
        // Indexes are not saved when we go back to the Main Menu
        if (settings.goToAndSelect(this._title)) {
            return(this.fromMenu(true));
        }
        UIALogger.logError(this._objectName + ".goTo(): failed to get to " + this._title);
        return(undefined);
    }
}
