//
//  vertex.vsh
//  LavaLamp
//
//  Created by Jacques Philippe Gasselin de Richebourg on 3/3/13.
//  Copyright (c) 2013 Apple Inc. All rights reserved.
//

attribute vec2 pos;
attribute vec2 texcoord;

varying mediump vec2 uv;

uniform vec4 viewport;
uniform vec2 tileSize;

void main(void) {
    uv = texcoord;
    
    const float quanta = 2.0;
    //quantize to some pixel multiple remembering that the xy component has factor of tileSize
    highp vec2 xy = floor(quanta * tileSize * (pos - viewport.xy)) / quanta;
    //convert to NDC
    highp vec2 ndc = (2.0 * (xy / viewport.zw) - 1.0);
    
    gl_Position = vec4(ndc, 0.0, 1.0);
}