#!/usr/bin/python

import xml.etree.ElementTree as ET
import os
import sys
import json

DEBUG_LOGGING = False
NAMESPACE_URI = 'http://www.apple.com/CoreAnimation/1.0'

def fixElement(e, srcMap):
	if e.tag.endswith('LKStateRemoveElement'):
		for child in e:
			if child.tag.endswith('object'):
				name = child.get('name', '')
				if name.startswith('__') or name == 'Titlebar Shadow':
					if DEBUG_LOGGING: print "#### Removing LKStateRemoveElement with name", name
					return None
	elif e.tag.endswith('CALayer'):
		name = e.get('name', '')
		if name == '__Xtras' or name == 'Titlebar Shadow' or name == '__Shake-Fine' or name == '__TYPE MESH Rightwards':
			if DEBUG_LOGGING: print "#### Removing CALayer with name", name
			return None
	elif e.tag.endswith('CAGradientLayer'):
		name = e.get('name', '')
		if name.startswith('__'):
			if DEBUG_LOGGING: print "#### Removing CAGradientLayer with name", name
			return None
	elif e.tag.endswith('scriptComponents'):
		if DEBUG_LOGGING: print "#### Removing scriptComponents"
		return None
	
	
	toRemove = [c for c in e if fixElement(c, srcMap) is None]
	for c in toRemove:
		e.remove(c)
	return e

def printUsageAndExit():
	print "#### Usage:", sys.argv[0], "<directory>"
	sys.exit(0)

if len(sys.argv) != 2: printUsageAndExit()
rootPath = sys.argv[1]
if not os.path.exists(rootPath): printUsageAndExit()
ET.register_namespace('', NAMESPACE_URI)

srcMap = {}
files = [f for f in os.listdir(rootPath) if f.endswith('.caml')]
for fname in files:
	fpath = os.path.join(rootPath, fname)
	if not os.path.exists(fpath):
		print "Error: could not open file", fpath
	if DEBUG_LOGGING: print "Processing file", fname
	startSize = os.path.getsize(fpath)
	tree = ET.parse(fpath)
	root = tree.getroot()
	fixElement(root, srcMap)
	tree.write(fpath, encoding="utf-8", xml_declaration=True)
	endSize = os.path.getsize(fpath)
	print "Reduced file {0} from {1} KB to {2} KB".format(fname, startSize / 1000, endSize / 1000)

if len(srcMap) > 0:
	# use values as keys when printed so that it's easy
	# to map them when parsing the CAML files
	swappedMap = dict((v,k) for k,v in srcMap.iteritems())
	print "Global src map:"
	print(json.dumps(swappedMap, indent=4))
else:
	print "No src map used"