/*
	File:		gpus_device.c

	Copyright:	(c) 1999-2013 by Apple Inc., all rights reserved.

	Writers:
		Bob Beretta
*/

#include "glr_config.h"

#include <GPUSupport/gpus_internal.h>
#include <GPUSupport/gpus_init.h>
#include <GPUSupport/gpus_device.h>
#include <GPUSupport/gpus_print.h>

enum32_t gldCreateDevice(GLDDevice *dev_ret, bitfield32_t display_mask,
	GLDDeviceConfig *config)
{
	GLDDevice device;
	enum32_t ret;

	#if GLR_PIPEPROG_HAS_CTX_BUILD
	config->per_context_programs = true;
	#endif

	// Call into GPUSupport with the IOData for this plugin.
	ret = gpumCreateDevice(dev_ret, display_mask, config, &gpus_io_data,
		glrPopulateDeviceConfig);

	if (ret != GLD_NO_ERROR)
	{
		*dev_ret = NULL;
		gpusPrintErr("%s: gpumCreateDevice failed: 0x%08x", __FUNCTION__, ret);
		return ret;
	}

	device = *dev_ret;

	device->dispatch.initialize_share_group_func                  = glrInitializeShareGroup;
	device->dispatch.terminate_share_group_func                   = glrTerminateShareGroup;
	device->dispatch.initialize_context_func                      = glrInitializeContext;
	device->dispatch.terminate_context_func                       = glrTerminateContext;
	#if GLR_BUILD_CL_GLD
	device->dispatch.initialize_queue_func                        = glrInitializeQueue;
	device->dispatch.terminate_queue_func                         = glrTerminateQueue;
	#else
	device->dispatch.initialize_queue_func                        = NULL;
	device->dispatch.terminate_queue_func                         = NULL;
	#endif
	device->dispatch.initialize_framebuffer_func                  = glrInitializeFramebuffer;
	device->dispatch.terminate_framebuffer_func                   = glrTerminateFramebuffer;
	device->dispatch.initialize_vertex_array_func                 = glrInitializeVertexArray;
	device->dispatch.terminate_vertex_array_func                  = glrTerminateVertexArray;
	device->dispatch.initialize_texture_func                      = glrInitializeTexture;
	device->dispatch.terminate_texture_func                       = glrTerminateTexture;
	device->dispatch.initialize_sampler_func                      = glrInitializeSampler;
	device->dispatch.terminate_sampler_func                       = glrTerminateSampler;
	device->dispatch.initialize_buffer_func                       = glrInitializeBuffer;
	device->dispatch.terminate_buffer_func                        = glrTerminateBuffer;
	device->dispatch.initialize_memory_plugin_func                = glrInitializeMemoryPlugin;
	device->dispatch.terminate_memory_plugin_func                 = glrTerminateMemoryPlugin;
	#if GLR_BUILD_CL_GLD
	device->dispatch.initialize_compute_module_func               = glrInitializeComputeModule;
	device->dispatch.terminate_compute_module_func                = glrTerminateComputeModule;
	device->dispatch.initialize_compute_program_func              = glrInitializeComputeProgram;
	device->dispatch.terminate_compute_program_func               = glrTerminateComputeProgram;
	device->dispatch.initialize_kernel_func                       = glrInitializeKernel;
	device->dispatch.terminate_kernel_func                        = glrTerminateKernel;
	#else
	device->dispatch.initialize_compute_module_func               = NULL;
	device->dispatch.terminate_compute_module_func                = NULL;
	device->dispatch.initialize_compute_program_func              = NULL;
	device->dispatch.terminate_compute_program_func               = NULL;
	device->dispatch.initialize_kernel_func                       = NULL;
	device->dispatch.terminate_kernel_func                        = NULL;
	#endif
	device->dispatch.initialize_query_func                        = NULL;
	device->dispatch.terminate_query_func                         = NULL;
	device->dispatch.initialize_query_buffer_func                 = glrInitializeQueryBuffer;
	device->dispatch.terminate_query_buffer_func                  = glrTerminateQueryBuffer;
	device->dispatch.sanitize_renderer_info_func                  = glrSanitizeRendererInfo;
	device->dispatch.validate_pixel_format_func                   = glrValidatePixelFormat;
	device->dispatch.populate_context_config_func                 = glrPopulateContextConfig;
	device->dispatch.update_framebuffer_func                      = glrUpdateFramebuffer;
	device->dispatch.update_vertex_array_state_func               = glrUpdateVertexArrayState;
	device->dispatch.update_vertex_array_buffers_func             = glrUpdateVertexArrayBuffers;
	device->dispatch.update_vertex_array_range_func               = glrUpdateVertexArrayRange;
	device->dispatch.update_texture_func                          = glrUpdateTexture;
	device->dispatch.update_texture_format_func                   = glrUpdateTextureFormat;
	device->dispatch.update_sampler_func                          = glrUpdateSampler;
	device->dispatch.update_buffer_func                           = glrUpdateBuffer;
	device->dispatch.update_context_draw_buffer_state_func        = glrUpdateContextDrawBufferState;
	device->dispatch.update_context_transform_feedback_state_func = glrUpdateContextTransformFeedbackState;
	device->dispatch.update_context_vertex_array_func             = glrUpdateContextVertexArray;
	device->dispatch.bind_context_draw_framebuffer_func           = glrBindContextDrawFramebuffer;
	device->dispatch.bind_context_read_framebuffer_func           = glrBindContextReadFramebuffer;
	device->dispatch.bind_context_vertex_array_func               = glrBindContextVertexArray;
	device->dispatch.bind_context_texture_func                    = glrBindContextTexture;
	device->dispatch.bind_context_sampler_func                    = glrBindContextSampler;
	device->dispatch.write_texture_data_func                      = glrWriteTextureData;
	device->dispatch.copy_framebuffer_data_to_texture_func        = glrCopyFramebufferDataToTexture;
	device->dispatch.copy_texture_data_func                       = glrCopyTextureData;
	device->dispatch.blit_texture_mipmaps_func                    = glrBlitTextureMipmaps;
	device->dispatch.write_buffer_data_func                       = glrWriteBufferData;
	device->dispatch.copy_buffer_data_func                        = glrCopyBufferData;
	device->dispatch.read_framebuffer_data_func                   = glrReadFramebufferData;
	device->dispatch.set_fence_on_context_func                    = glrSetFenceOnContext;
	device->dispatch.set_fence_on_queue_func                      = glrSetFenceOnQueue;
	device->dispatch.flush_context_token_func                     = glrFlushContextToken;
	#if GLR_BUILD_CL_GLD
	device->dispatch.flush_queue_func                             = gldFlushQueue;
	#else
	device->dispatch.flush_queue_func                             = NULL;
	#endif
	device->dispatch.get_private_integer_func                     = glrGetPrivateInteger;
	device->dispatch.set_private_integer_func                     = glrSetPrivateInteger;
	#ifndef GPUS_MERCURY
	device->dispatch.purge_texture_func                           = glrPurgeSysTexture;
	device->dispatch.unpurge_texture_func                         = glrUnpurgeSysTexture;
	device->dispatch.purge_buffer_func                            = glrPurgeSysBufferObject;
	device->dispatch.unpurge_buffer_func                          = glrUnpurgeSysBufferObject;
	#endif

	return GLD_NO_ERROR;
}
