#import "Power_Cat5_harness.js"

// This is just a convenience wrapper for the command line.
// Example: /usr/local/bin/scripter -i /usr/local/etc/scripterUIA/other/power/Power_Cat5_singleTest.js -c "executeSingleTest('Browse Web', 'doWebBrowse', '', 120, 1, false, false)
function executeSingleTest(name, func, args, minutes, activations, randLength, randOrder) {
    UIALogger.logMessage("executeSingleTest inputs:\n" +
                         "Name: " + name + "\n" +
                         "Function: " + func + "\n" +
                         "Args: " + args + "\n" +
                         "Minutes: " + minutes + "\n" +
                         "Activations: " + activations + "\n" +
                         "randLength: " + randLength + "\n" +
                         "randOrder: " + randOrder);

    // Check if function, minutes, or activations is undefined
    if (isEmpty(func) || isEmpty(minutes) || isEmpty(activations)) {
        throw new Error("Func, minutes, and activations must be defined!");
    }

    addTest({name:name, func:func, args:args, minutes:minutes, activations:activations, randLength:randLength, randOrder:randOrder});
    startTest();
}

function isEmpty(str) {
    return (!str || 0 === str.length);
}