/*
	File:		gpus_query.c

	Copyright:	© 1999-2010 by Apple Inc., all rights reserved.

	Writers:
		Bob Beretta
*/

#include "glr_config.h"

#include <GPUSupport/gpus_internal.h>
#include <GPUSupport/gpus_query.h>
#include <GPUSupport/gpus_export.h>

#if defined(GPUS_MERCURY) && !GLR_CLIENT_ALLOC_QUERY_BUFFER
#error "Mercury wants you allocate query buffer using a texture"
#endif

#if !GLR_CLIENT_ALLOC_QUERY_BUFFER
kern_return_t glrGetQueryBuffer(mach_port_t con, void **buffer, unsigned int *size)
{
	return glkern_get_query_buffer(con, buffer, size);
}
#endif // !GLR_CLIENT_ALLOC_QUERY_BUFFER

enum32_t gldCreateQuery(GLDContext ctx, GLDQuery *query_ret)
{
	return gpumCreateQuery(ctx, query_ret,
		#if !GLR_CLIENT_ALLOC_QUERY_BUFFER
		0L,
		glrGetQueryBuffer
		#else // GLR_CLIENT_ALLOC_QUERY_BUFFER
		sizeof(struct GLRQueryBufferClientAlloc),
		NULL
		#endif // GLR_CLIENT_ALLOC_QUERY_BUFFER
		);
}

enum32_t gldModifyQuery(GLDContext ctx, GLDQuery query, enum32_t pname, const int64_t *params)
{
	return gpumModifyQuery(ctx, query, pname, params, glrEndQuery, glrSetQueryCounter);
}

enum32_t gldGetQueryInfo(GLDContext ctx, GLDQuery query, enum32_t pname, int64_t *params)
{
	return gpumGetQueryInfo(ctx, query, pname, params, glrBeginQuery, glrEndQuery, glrGetQueryInfo);
}

enum32_t gldDestroyQuery(GLDContext ctx, GLDQuery query)
{
	return gpumDestroyQuery(ctx, query, glrEndQuery);
}

void gpusLoadCurrentQueries(GLDContext ctx)
{
	gpumLoadCurrentQueries(ctx, glrBeginQuery, glrEndQuery);
}

