/*
	File:		gpus_compute_context.c

	Copyright:	© 2008-2010 by Apple Inc., all rights reserved.

	Writers:
		Michael Larson
		Bob Beretta
*/


#include "glr_config.h"

#include <GPUSupport/gpus_internal.h>
#include <GPUSupport/gpus_export.h>
#include <GPUSupport/gpus_compute_context.h>

#include <GPUSupport/GIO/GIOCTAssert.h>


#if GLR_BUILD_CLD == 1

enum32_t gldCreateComputeContext(GLDComputeContext *ccx_ret, GLDShareGroup shared,
	bitfield32_t display_mask)
{
	enum32_t ret;

	ret = gpumCreateComputeContext(ccx_ret, shared, display_mask, glrInitializeComputeContext);

	return ret;
}

enum32_t gldDestroyComputeContext(GLDComputeContext ccx)
{
	enum32_t ret;

	ret = gpumDestroyComputeContext(ccx, glrTerminateComputeContext);
	return ret;
}


enum32_t gpusCompCreateFence(GLDComputeContext ccx, GLDFence *fence_ret)
{
	return gpumCompCreateFence(ccx, fence_ret);
}

void gpusCompDestroyFence(GLDComputeContext ccx, GLDFence fence)
{
	gpumCompDestroyFence(ccx, fence);
}

bool32_t gpusCompTestFence(GLDComputeContext ccx, GLDFence fence)
{
	return gpumCompTestFence(ccx, fence);
}

bool32_t gpusCompFinishFence(GLDComputeContext ccx, GLDFence fence)
{
	return gpumCompFinishFence(ccx, fence);
}

bool32_t gpusCompGetFenceStatus(GLDComputeContext ccx, GLDFence fence, uint32_t *status)
{
	return gpumCompGetFenceStatus(ccx, fence, status);
}

bool32_t gpusCompGetFenceProfilingInfo(GLDComputeContext ccx, GLDFence fence,
	uint64_t *start_time, uint64_t *finish_time, uint64_t *enqueue_time)
{
	return gpumCompGetFenceProfilingInfo(ccx, fence, start_time, finish_time, enqueue_time);
}

void gpusAcquireFenceOnQueue(GLDQueue queue, GLDFence fence)
{
    gpumAcquireFenceOnQueue(queue, fence);
}

void gpusSetFenceOnQueue(GLDQueue queue, GLDFence fence)
{
    gpumSetFenceOnQueue(queue, fence);
}

#endif // GLR_BUILD_CLD

#include <OpenGLES/cl_driver_types.h>

// These constants have to stay in lock step for now.
ct_assert(CLD_ARGS_FLAGS_IMAGE == GLD_KERNEL_ARGS_IMAGE_BIT);
ct_assert(CLD_ARGS_FLAGS_GLOBAL == GLD_KERNEL_ARGS_GLOBAL_BIT);
ct_assert(CLD_ARGS_FLAGS_LOCAL == GLD_KERNEL_ARGS_LOCAL_BIT);
ct_assert(CLD_ARGS_FLAGS_CONST == GLD_KERNEL_ARGS_CONST_BIT);
ct_assert(CLD_ARGS_FLAGS_RD == GLD_KERNEL_ARGS_RD_BIT);
ct_assert(CLD_ARGS_FLAGS_WR == GLD_KERNEL_ARGS_WR_BIT);
ct_assert(CLD_ARGS_FLAGS_NORMALIZED == GLD_KERNEL_ARGS_NORMALIZED_BIT);
ct_assert(CLD_ARGS_FLAGS_SAMPLER == GLD_KERNEL_ARGS_SAMPLER_BIT);
ct_assert(CLD_ARGS_FLAGS_DEVICE == GLD_KERNEL_ARGS_DEVICE_BIT);
ct_assert(CLD_ARGS_FLAGS_USER_ASSIGNED == GLD_KERNEL_ARGS_USER_ASSIGNED_BIT);

ct_assert(CLD_LOCAL == GLD_COMPUTE_LOCAL_MEM_TYPE_LOCAL);
ct_assert(CLD_GLOBAL == GLD_COMPUTE_LOCAL_MEM_TYPE_GLOBAL);

ct_assert(CLD_CACHE_R == GLD_COMPUTE_CACHE_TYPE_READ_ONLY);
ct_assert(CLD_CACHE_RW == GLD_COMPUTE_CACHE_TYPE_READ_WRITE);
ct_assert(CLD_NONE == GLD_COMPUTE_CACHE_TYPE_NONE);

ct_assert(CLD_EXEC_KERNEL == GLD_COMPUTE_EXEC_KERNEL_BIT);
ct_assert(CLD_EXEC_NATIVE_FN == GLD_COMPUTE_EXEC_NATIVE_FN_BIT);

ct_assert(CLD_QUEUE_OOO_EXEC_AVAILABLE == GLD_DEVICE_QUEUE_PROPS_OOO_EXEC_BIT);
ct_assert(CLD_QUEUE_PROFILING_AVAILABLE == GLD_DEVICE_QUEUE_PROPS_PROFILING_BIT);

ct_assert(CLD_FP_DENORM == GLD_COMPUTE_FP_DENORM_BIT);
ct_assert(CLD_FP_INF_NAN == GLD_COMPUTE_FP_INF_NAN_BIT);
ct_assert(CLD_FP_ROUND_TO_NEAREST == GLD_COMPUTE_FP_ROUND_TO_NEAREST_BIT);
ct_assert(CLD_FP_ROUND_TO_ZERO == GLD_COMPUTE_FP_ROUND_TO_ZERO_BIT);
ct_assert(CLD_FP_ROUND_TO_INF == GLD_COMPUTE_FP_ROUND_TO_INF_BIT);
ct_assert(CLD_FP_FMA == GLD_COMPUTE_FMA_BIT);
ct_assert(CLD_FP_SOFT_FLOAT == GLD_COMPUTE_SOFT_FLOAT_BIT);
ct_assert(CLD_FP_CORRECTLY_ROUNDED_DIVIDE_SQRT == GLD_FP_CORRECTLY_ROUNDED_DIVIDE_SQRT_BIT);

ct_assert(CLD_ADDRESS_REPEAT == GLD_SAMPLER_ADDRESS_REPEAT);
ct_assert(CLD_ADDRESS_MIRRORED_REPEAT == GLD_SAMPLER_ADDRESS_MIRRORED_REPEAT);
ct_assert(CLD_ADDRESS_CLAMP == GLD_SAMPLER_ADDRESS_CLAMP);
ct_assert(CLD_ADDRESS_CLAMP_TO_EDGE  == GLD_SAMPLER_ADDRESS_CLAMP_TO_EDGE);
ct_assert(CLD_ADDRESS_NONE == GLD_SAMPLER_ADDRESS_NONE);
ct_assert(CLD_FILTER_NEAREST == GLD_SAMPLER_FILTER_NEAREST);
ct_assert(CLD_FILTER_LINEAR == GLD_SAMPLER_FILTER_LINEAR);
ct_assert(CLD_NORMALIZED == GLD_SAMPLER_NORMALIZED);

#include <OpenGLES/cl_driver_interface.h>

#if (GLR_BUILD_CLD == 0)

// !GLR_BUILD_CLD For drivers that don't support the native OpenCL cld interface this provides a set of null functions so the exp doesn't fail

enum32_t gldCreateComputeContext(GLDComputeContext *ccx_ret, GLDShareGroup shared,
	bitfield32_t display_mask)
{
#pragma unused(ccx_ret, shared, display_mask)
	return -1;
}

enum32_t gldDestroyComputeContext(GLDComputeContext ccx)
{
#pragma unused(ccx)
	return -1;
}

enum32_t gpusCompCreateFence(GLDComputeContext ccx, GLDFence *fence_ret)
{
#pragma unused(ccx, fence_ret)
	return -1;
}

bool32_t gpusCompTestFence(GLDComputeContext ccx, GLDFence fence)
{
#pragma unused(ccx, fence)
	return false;
}

bool32_t gpusCompFinishFence(GLDComputeContext ccx, GLDFence fence)
{
#pragma unused(ccx, fence)
	return false;
}

void gpusCompDestroyFence(GLDComputeContext ccx, GLDFence fence)
{
#pragma unused(ccx, fence)
}

bool32_t gpusCompGetFenceStatus(GLDComputeContext ccx, GLDFence fence, uint32_t *status)
{
#pragma unused(ccx, fence, status)
	return 0;
}

bool32_t gpusCompGetFenceProfilingInfo(GLDComputeContext ccx, GLDFence fence, uint64_t *start_time, uint64_t *finish_time, uint64_t *enqueue_time)
{
#pragma unused(ccx, fence, start_time, finish_time, enqueue_time)
	return 0;
}

#endif // (GLR_BUILD_CLD == 0)

#if (GLR_BUILD_CLD == 0) || (GLR_BUILD_CL_GLD == 1)

// !GLR_BUILD_CLD For drivers that don't support the native OpenCL cld interface this provides a set of null functions so the exp doesn't fail
// GLR_BUILD_GL_CLD For drivers that support compute via the AGP4 interface (not CLD).


int glrCompOpenDevice(cld_context_properties_t *properties, GLDShareGroup shared,
	GLDDispatch gld_dispatch, cld_device *device_ret)
{
#pragma unused(properties, shared, gld_dispatch, device_ret)
	return -1;
}

int glrCompCloseDevice(cld_device device)
{
#pragma unused(device)
	return -1;
}

int glrCompGetDeviceConfig(cld_device device, cl_device_config_t *config)
{
#pragma unused(device, config)
	return -1;
}

int glrCompCreateStream(cld_device device, void *gld_object, cl_bitfield flags,
												cld_mem_object_type type, cld_stream_desc_t *desc,
												void *ptr, cld_stream *ret)
{
#pragma unused(device, gld_object, flags, type, desc, ptr, ret)
	return -1;
}

int glrCompDeleteStream(cld_stream stream)
{
#pragma unused(stream)
	return -1;
}

int glrCompFinishStream(cld_context context, cld_stream stream)
{
#pragma unused(context, stream)
	return -1;
}

int glrCompReadStream(cld_queue queue,
                      cld_stream_dim_t* src_dim, cld_stream src_stream,
                      cld_stream_dim_t* dst_dim, cld_buffer_t* dst_buffer,
                      unsigned blocking, cld_event *event_out)
{
#pragma unused(queue, src_dim, src_stream, dst_dim, dst_buffer, blocking, event_out)
	return -1;
}

int glrCompWriteStream(cld_queue queue,
                       cld_stream_dim_t* src_dim, cld_buffer_t* src_buffer,
                       cld_stream_dim_t* dst_dim, cld_stream dst_stream,
                       unsigned blocking, cld_event *event_out) 
{
#pragma unused(queue, src_dim, src_buffer, dst_dim, dst_stream, blocking, event_out)
	return -1;
}

int glrCompCopyStream(cld_queue queue,
                      cld_stream_dim_t *src_dim, cld_stream src_stream,
                      cld_stream_dim_t *dst_dim, cld_stream dst_stream,
                      cld_event *event_out)
{
#pragma unused(queue, src_dim, src_stream, dst_dim, dst_stream, event_out)
	return -1;
}

int glrCompGetImageFormats(cld_device device, cl_bitfield flags,
                           cld_mem_object_type type, unsigned formats_size, 
                           cld_image_format *formats, unsigned *num_formats)
{
#pragma unused(device, flags, type, formats_size, formats, num_formats)
	return -1;
}

int glrCompCreateProgram(cld_device device, cld_program *program_out)
{
#pragma unused(device, program_out)
	return -1;
}

int glrCompDeleteProgram(cld_program program)
{
#pragma unused(program)
	return -1;
}

int glrCompBuildProgram(cld_program program, cld_comp_opt opt, char *options,
	const void *source, size_t source_size, char **compile_log, void **binary,
	size_t *bin_size, int *bin_vers)
{
#pragma unused(program, opt, options, source, compile_log, binary, bin_size, bin_vers)
	return -1;
}

int glrCompLoadBinary(cld_program program, void *binary, size_t length, int version)
{
#pragma unused(program, binary, length, version)
  return -1;
}

CFArrayRef glrCompGetKernelNames(cld_program program)
{
#pragma unused(program)
	return NULL;
}

int glrCompGetKernelArgInfo(cld_program program, const char *kernel_name,
	size_t *n_args, size_t *arg_sizes,
	cl_bitfield *arg_flags)
{
#pragma unused(program, kernel_name, n_args, arg_sizes, arg_flags)
	return -1;
}

int glrCompCreateKernel(cld_program program, const char *kernel_name,
	cld_kernel *kernel_out)
{
#pragma unused(program, kernel_name, kernel_out)
	return -1;
}

int glrCompGetKernelInfo(cld_kernel kernel, cld_workgroup_info key,
	uint64_t *value)
{
#pragma unused(kernel, key, value)
	return -1;
}

int glrCompDeleteKernel(cld_kernel kernel)
{
#pragma unused(kernel)
	return -1;
}

int glrCompExecuteKernel(cld_context context, cld_kernel kernel,
                         unsigned num_dims, size_t *global_offset,
                         size_t *global_dim, size_t *local_dim, size_t num_args,
                         void **arg_values, size_t *arg_sizes,
                         cl_bitfield *arg_flags, cld_event *event_out)
{
#pragma unused(context, kernel, num_dims, global_offset, global_dim, local_dim, num_args, arg_values, arg_sizes, arg_flags, event_out)
	return -1;
}

int glrCompExecuteNativeKernel(cld_queue queue, void (*fn)(void *), 
                               void **args, cld_stream *mem_args,
                               void **args_locs, unsigned num_mem_args,
                               cld_event *event_out)
{
#pragma unused(queue, fn, args, mem_args, args_locs, num_mem_args, event_out)
	return -1;
}

int glrCompEnqueueMarker(cld_context context, cld_event *event_out)
{
#pragma unused(context, event_out)
  return -1;
}

int glrCompGetEventStatus(cld_event event)
{
#pragma unused(event)
  return -1;
}

int glrCompWaitForEvent(cld_event event, uint64_t *start_time, uint64_t *finish_time, uint64_t *enqueue_time, uint64_t *submit_time)
{
#pragma unused(event, start_time, finish_time, enqueue_time, submit_time)
	return -1;
}

int glrCompDeleteEvent(cld_event event)
{
#pragma unused(event)
	return -1;
}

int glrCompCreateContext(GLDComputeContext ccx, cld_device device,
	cld_context_properties_t *properties, cld_context *ccx_ret)
{
#pragma unused(ccx, device, properties, ccx_ret)
	return -1;
}

void glrCompDeleteContext(cld_context context)
{
#pragma unused(context)
}

int glrCompFlush(cld_context context)
{
#pragma unused(context)
	return -1;
}

int glrCompFinish(cld_context context)
{
#pragma unused(context)
	return -1;
}

int glrCompSetContextProperties(cld_context context, cld_qproperties props)
{
#pragma unused(context, props)
	return -1;
}

#endif // #if (GLR_BUILD_CLD == 0) || (GLR_BUILD_CL_GLD == 1)


#if !GLR_BUILD_CL_GLD
//
// The following entry points are implemented by a device-specific plugin.
// If a plugin doesn't use the CL-specific GLD interface, it must include these stubs.
//

void gldWaitForFenceOnQueue(GLDQueue que, GLDFence fence)
{
	#pragma unused(que, fence)
}

enum32_t gldCreateDevicePartitionGroup(
    GLDDevice dev,
    GLDDevicePartitionGroup *grp_ret,
    GLDDevicePartition prt,
    enum32_t *props,
    int32_t *num_prts)
{
#pragma unused(dev, grp_ret, prt, props, num_prts)
	return GLD_NO_ERROR;
}

enum32_t gldDestroyDevicePartitionGroup(
    GLDDevice dev,
    GLDDevicePartitionGroup grp)
{
#pragma unused(dev, grp)
	return GLD_NO_ERROR;
}

enum32_t gldCreateDevicePartition(
    GLDDevice dev,
    GLDDevicePartition *prt_ret,
    GLDDevicePartitionGroup grp,
    int32_t index)
{
#pragma unused(dev, prt_ret, grp, index)
	return GLD_NO_ERROR;
}

enum32_t gldDestroyDevicePartition(
    GLDDevice dev,
    GLDDevicePartition prt)
{
#pragma unused(dev, prt)
	return GLD_NO_ERROR;
}

enum32_t gldGetDevicePartitionInfo(
    GLDDevice dev,
    GLDDevicePartition prt,
    enum32_t pname,
    int32_t *params)
{
#pragma unused(dev, prt, pname, params)
	return GLD_NO_ERROR;
}

enum32_t gldCompileComputeModule(GLDShareGroup shared, GLDComputeModule module_out,
	const void *source, size_t src_size,
	bitfield32_t flags, char *options)
{
#pragma unused(shared, module_out, source, src_size, flags, options)
	return GLD_NO_ERROR;
}

enum32_t gldLinkComputeModules(GLDShareGroup shared, GLDComputeModule module_out,
	GLDComputeModule *modules, int32_t num_modules,
	enum32_t flags, char *options)
{
#pragma unused(shared, module_out, modules, num_modules, flags, options)
	return GLD_NO_ERROR;
}

enum32_t gldLinkComputeProgram(GLDShareGroup shared, GLDComputeProgram program_out,
	GLDComputeModule *modules, int32_t num_modules,
	enum32_t flags, char *options)
{
#pragma unused(shared, program_out, modules, num_modules, flags, options)
	return GLD_NO_ERROR;
}

enum32_t gldWriteComputeProgramBinary(GLDShareGroup share_group, GLDComputeProgram program, 
	void *binary, size_t length, uint32_t version)
{
#pragma unused(share_group, program, binary, length, version)
    return GLD_NO_ERROR;
}

enum32_t gldExecuteKernel(GLDQueue queue, GLDKernel kernel,
	unsigned num_dims, size_t *global_offset, size_t *global_dim, size_t *local_dim, 
    size_t num_args, void **arg_values, size_t *arg_sizes, bitfield32_t *arg_flags, GLDFence fence)
{
#pragma unused(queue, kernel, num_dims, global_offset, global_dim, local_dim, num_args, arg_values, arg_sizes, arg_flags, fence)
    return GLD_NO_ERROR;
}

enum32_t gldExecuteNativeKernel(GLDQueue queue, void (*fn)(void *), 
	void **args, size_t arg_bytes, void *mem_args, void **args_locs, 
    unsigned num_mem_args, GLDFence fence)
{
#pragma unused(queue, fn, args, arg_bytes, mem_args, args_locs, num_mem_args, fence)
    return GLD_NO_ERROR;
}

enum32_t gldCopyBufferDataWithQueue(GLDQueue queue,
	GLDBufferImageRegion *src_dim, GLDBuffer src_buffer,
	GLDBufferImageRegion *dst_dim, GLDBuffer dst_buffer,
	bitfield32_t options, GLDFence fence)
{
#pragma unused(queue, src_dim, src_buffer, dst_dim, dst_buffer, options, fence)
	return 0;
}

enum32_t gldCopyTextureDataWithQueue(GLDQueue queue,
	GLDTextureImageRegion *src_dim, GLDTexture src_texture,
	GLDTextureImageRegion *dst_dim, GLDTexture dst_texture,
	bitfield32_t options, GLDFence fence)
{
#pragma unused(queue, src_dim, src_texture, dst_dim, dst_texture, options, fence)
	return 0;
}

enum32_t gldCopyBufferDataToTextureWithQueue(GLDQueue queue,
	GLDBufferImageRegion *src_dim, GLDBuffer src_buffer,
	GLDTextureImageRegion *dst_dim, GLDTexture dst_texture,
	bitfield32_t options, GLDFence fence)
{
#pragma unused(queue, src_dim, src_buffer, dst_dim, dst_texture, options, fence)
	return 0;
}

enum32_t gldCopyTextureDataToBufferWithQueue(GLDQueue queue,
	GLDTextureImageRegion *src_dim, GLDTexture src_texture,
	GLDBufferImageRegion *dst_dim, GLDBuffer dst_buffer,
	bitfield32_t options, GLDFence fence)
{
#pragma unused(queue, src_dim, src_texture, dst_dim, dst_buffer, options, fence)
	return 0;
}

bool32_t glrSetFenceOnQueue(GLDQueue queue, GLDFence fence)
{
#pragma unused(queue, fence)
	return false;
}

void gldGetFenceProfilingInfo(GLDShareGroup shared,
	GLDFence fence, GLDFenceProfilingInfo *info)
{
#pragma unused(shared, fence, info)
}

void gldFlushQueue(GLDQueue queue)
{
#pragma unused(queue)
}

enum32_t gldFinishQueue(GLDQueue queue)
{
#pragma unused(queue)
    return GLD_NO_ERROR;
}

void glrInitializeQueue(GLDQueue queue)
{
#pragma unused(queue)
    return;
}

void glrTerminateQueue(GLDQueue queue)
{
#pragma unused(queue)
    return;
}


void glrInitializeComputeProgram(GLDShareGroup share_group, GLDComputeProgram program)
{
#pragma unused(share_group, program)
    return;
}

void glrTerminateComputeProgram(GLDShareGroup share_group, GLDComputeProgram program)
{
#pragma unused(share_group, program)
    return;
}

void glrInitializeKernel(GLDShareGroup share_group, GLDComputeProgram program, GLDKernel kernel)
{
#pragma unused(share_group, program, kernel)
    return;
}

void glrTerminateKernel(GLDShareGroup share_group, GLDComputeProgram program, GLDKernel kernel)
{
#pragma unused(share_group, program, kernel)
    return;
}


#endif // !GLR_BUILD_CL_GLD

