# GPUSupport configuration

# This tells MAKE not to automatically delete these types of intermediate files
.PRECIOUS: %.ppc.o %.i386.o %.ppc64.o %.x86_64.o

# Framework paths
GPUM_PUBLIC_FRAMEWORK_PATH     := ${GLR_FRAMEWORK_ROOT}/System/Library/Frameworks
GPUM_PRIVATE_FRAMEWORK_PATH    := ${GLR_FRAMEWORK_ROOT}/System/Library/PrivateFrameworks
GPUM_OPENGL_FRAMEWORK_PATH     := ${GPUM_PUBLIC_FRAMEWORK_PATH}/OpenGL.framework
GPUM_GPUSUPPORT_FRAMEWORK_PATH := ${GPUM_PRIVATE_FRAMEWORK_PATH}/GPUSupport.framework

# Source directories
VPATH := ${GPUM_GPUSUPPORT_FRAMEWORK_PATH}/PrivateSources ${VPATH}

# Exports file
EXPORTS := ${GPUM_GPUSUPPORT_FRAMEWORK_PATH}/PrivateResources/GLRendererOSX.exp

# The ASSERT env var is used to turn assertions on in the release build
ASSERT := $(shell echo $$ASSERT)
ifneq "${ASSERT}" "1"
ASSERT := 0
endif

# We normally build IOSurface.  Building without is essentially unsupported
IOSURFACE := $(shell echo $$IOSURFACE)
ifneq "${IOSURFACE}" "0"
IOSURFACE := 1
endif

# Warnings
ifeq "${ASSERT}" "1"
WARNERROR := -Werror
else
WARNERROR :=
endif

CWARNINGS = ${WARNERROR} -Wall -Wmissing-prototypes -Wno-four-char-constants -Wno-unused-variable
CPPWARNINGS = ${WARNERROR} -Wall -Wno-four-char-constants -Wno-unused-variable

# Compiler Options
CBASEOPTIONS := -g -force_cpusubtype_ALL -DGLR_IOSURFACE=${IOSURFACE} -F${GPUM_PUBLIC_FRAMEWORK_PATH} -F${GPUM_PRIVATE_FRAMEWORK_PATH}

ifeq "${OPTFLAG}" ""
RELEASE_OPTFLAG = -Os
DEBUG_OPTFLAG = -O0
else
RELEASE_OPTFLAG = ${OPTFLAG}
DEBUG_OPTFLAG = ${OPTFLAG}
endif

CRELEASEOPTIONS := ${CBASEOPTIONS} ${RELEASE_OPTFLAG} -DGLR_DEBUG=0 -DGLR_ASSERT=${ASSERT}
CDEBUGOPTIONS   := ${CBASEOPTIONS} ${DEBUG_OPTFLAG} -DGLR_DEBUG=1 -DGLR_ASSERT=1

# Linker Options
LDBASEOPTIONS := -bundle

ifndef LDPIPEOPTION
LDBASEOPTIONS := -pipe ${LDBASEOPTIONS}
else
LDBASEOPTIONS := ${LDPIPEOPTION} ${LDBASEOPTIONS}
endif

LDBASEOPTIONS := ${LDBASEOPTIONS} -L${NEXT_ROOT}${GPUM_OPENGL_FRAMEWORK_PATH}/Libraries -L${NEXT_ROOT}${GPUM_GPUSUPPORT_FRAMEWORK_PATH}/Libraries

ifeq "${IOSURFACE}" "1"
LDBASEOPTIONS := ${LDBASEOPTIONS} -framework IOSurface
endif

ifeq "${IOACCEL}" "1"
LDBASEOPTIONS := ${LDBASEOPTIONS} -F${SDKROOT}/System/Library/PrivateFrameworks -framework IOAccelerator
endif

LDBASEOPTIONS := ${LDBASEOPTIONS} -framework CoreFoundation -framework IOKit

ifeq "${GPUS_MERCURY}" "1"
LDBASEOPTIONS := ${LDBASEOPTIONS} -lGLProgrammability -lGLImage -lGPUSupportMercury
else
LDBASEOPTIONS := ${LDBASEOPTIONS} -lGLProgrammability -lGLImage -lGPUSupport
endif

FIRST_PASS_MERC := ${GPUS_MERCURY}

LDRELEASEOPTIONS := ${LDBASEOPTIONS}

LDDEBUGOPTIONS   := ${LDBASEOPTIONS} -lGLPrint

# NOTE: If this list changes, we need to change the xcodeproject for the ES drivers build as well.
# Source files
GPUS_C_SOURCES := \
gpus_compute_context.c \
gpus_device.c \
gpus_format.c \
gpus_init.c \
gpus_program.c \
gpus_query.c \
gpus_texture.c

GPUS_CPP_SOURCES :=

